/***************************************************************************
                         dateplugin.cpp  -  description
                             -------------------
    begin                : Mon Feb 02 2004
    copyright            : (C) 2004 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "dateplugin.h"

// Qt includes
#include <qdatetime.h>

// KDE includes
#include <kfileitem.h>
#include <kio/netaccess.h>
#include <klocale.h>

DatePlugin::DatePlugin()
 : FilePlugin(0)
{
    keys.append("date");
    keys.append("date;.*");
    keys.append("year");
    keys.append("month");
    keys.append("day");
    keys.append("time");
    keys.append("hour");
    keys.append("minute");
    keys.append("second");
    keys.append("user");
    keys.append("group");
    keys.append("creationdate");
    keys.append("creationdate;.*");
    keys.append("modificationdate");
    keys.append("modificationdate;.*");
    keys.append("accessdate");
    keys.append("accessdate;.*");
    setupKeys();
 
    m_icon = "clock";   
}


QString DatePlugin::processFile(BatchRenamer* b, int i, QString token, int )
{
    if( !supports( token ) )
        return QString::null;
    
    if( token.lower().startsWith( getPattern() ) )
        token = token.mid( getPattern().length(), token.length() - getPattern().length() );
      
    
    QDate d = QDate::currentDate();
    QTime t = QTime::currentTime();
    QString tmp, text;
    QString format = "dd-MM-yyyy";
    if( token.contains( ";" ) )
    {
        format = token.section( ';', 1, 1 );
        token = token.section( ';', 0, 0 ).lower();
    } else 
        token = token.lower();

    if( token == "date" ) {
        return QDateTime::currentDateTime().toString( format );
    } else if( token == "year" )
        return QString( "%1" ).arg( d.year() );
    else if( token == "month" )
        return tmp.sprintf("%0*i", 2, d.month() );
    else if( token == "day" )
        return tmp.sprintf("%0*i", 2, d.day() );
    else if( token == "time" )
        return QString( "%1-%2-%3" ).arg( t.hour() ).arg( tmp.sprintf("%0*i", 2, t.minute() ) ).arg( tmp.sprintf("%0*i", 2, t.second() ) );
    else if( token == "hour" )
        return tmp.sprintf("%0*i", 2, t.hour() );
    else if( token == "minute" )
        return tmp.sprintf("%0*i", 2, t.minute() );
    else if( token == "second" )
        return tmp.sprintf("%0*i", 2, t.second() );
    else {
        KIO::UDSEntry entry;
        KIO::NetAccess::stat( b->files()[i].src.url, entry );
        KFileItem item( entry, b->files()[i].src.url );
        if( token == "user" )
            return item.user();
        else if( token == "group" )
            return item.group();
        else if( token == "creationdate" )
            return time( item.time( KIO::UDS_CREATION_TIME ), format );
        else if( token == "modificationdate" )
            return time( item.time( KIO::UDS_MODIFICATION_TIME ), format );
        else if( token == "accessdate" )
            return time( item.time( KIO::UDS_ACCESS_TIME ), format );
        
    }
    
    return QString::null;    
}

const QString DatePlugin::getAccelName() const
{
    return i18n("&System Functions");
}

const QString DatePlugin::getName() const
{
    return i18n("System Functions");
}

const QString DatePlugin::getPattern() const
{
    return QString::null;
}

const QString DatePlugin::time( time_t time, const QString & format )
{
    QDateTime dt;
    dt.setTime_t( time );
    return dt.toString( format );
}

void DatePlugin::addHelp( HelpDialogData* data )
{
    QStringList list;
    list.append( "[date];;" + i18n("Insert the current date") );
    list.append( "[date;yyyy-MM-dd];;" + i18n("Insert the current date using the formatting string yyyy-MM-dd") );
    list.append( "[year];;" + i18n("Insert the current year") );
    list.append( "[month];;" + i18n("Insert the current month as number") );
    list.append( "[day];;" + i18n("Insert the current day as number") );
    list.append( "[time];;" + i18n("Insert the current time") );
    list.append( "[hour];;" + i18n("Insert the current hour as number") );
    list.append( "[minute];;" + i18n("Insert the current minute as number") );
    list.append( "[second];;" + i18n("Insert the current second as number") );
    list.append( "[user];;" + i18n("Insert your username") );
    list.append( "[group];;" + i18n("Insert your groupname") );
    list.append( "[creationdate];;" + i18n("Insert the files creation date"));
    list.append( "[creationdate;yyyy-MM-dd];;" + i18n("Insert the formatted file creation date") );
    list.append( "[modificationdate];;" + i18n("Insert the files modification date"));
    list.append( "[modificationdate;yyyy-MM-dd];;" + i18n("Insert the formatted modification date") );
    list.append( "[accessdate];;" + i18n("Insert the date of the last file access") );
    list.append( "[accessdate;yyyy-MM-dd];;" + i18n("Insert the formatted date of the last file access") );

    data->add( getName(), &list, getIcon() );
}
