/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _KKDWIDGET_H_
#define _KKDWIDGET_H_
#include "../kkglobal.h"

#include "../kkwidgetbase.h"

class KURL;
/**
 * @namespace KKDesigner
 * @english
 * @brief namespace of designer pane
 *
 * This namespace is defined for src/kkdesigner/ to make libkkdesigner.la.
 * @endenglish
 *
 * @japanese
 * @brief デザイナぺインの名前空間
 *
 * この名前空間は src/kkdesigner/ のファイルに対して定義され、libkkdesigner.la を作成するために使われます。
 * @endjapanese
 * @see KKTemplate
 * @see KKAddressBook
 */
namespace KKDesigner
{
	class KKDView;
	class KKDDoc;

	class KKDWidget : public KKWidgetBase
	{
		Q_OBJECT
	public:
		KKDWidget( KCommandHistory* cmdHistory, QWidget* parent = 0, const char* name = 0 );
		virtual ~KKDWidget();
		const char* xmlFile(){ return "kkdesignerui.rc"; }
		bool closable();
		void readConfig( KConfig* conf );
		void saveConfig( KConfig* conf );

		KKDDoc* document(){ return m_doc; }

	public slots:
		void fileNew( const QString& filename );
		void fileOpen( const QString& filename, bool blCheckChanged = false );
		void tabChanged( QWidget* wgt );

	private slots:
		//BEGIN File Menu
		void fileOpen();
		void openRecent( const KURL& );
		bool fileSave();
		bool fileSaveAs();
		void print();
		void fileClose();
		//END File Menu

		//BEGIN Edit Menu
		void setLocked();

		void setFontFamily( const QString& f );
		void setFontSize( int s );
		void setFontBold();
		void setFontItalic();
		void setFontUnderline();
		void setFontStrikeOut();
		void setOrientation();
		void setAlign();
		void setColor();

		void setImagePrint();
		//END Edit Menu

		//BEGIN Set action's value
		void setActionLocked();

		void setActionFontFamily();
		void setActionFontSize();
		void setActionFontBold();
		void setActionFontItalic();
		void setActionFontUnderline();
		void setActionFontStrikeOut();
		void setActionOrientation();
		void setActionAlign();
		void setActionColor();
		
		void setActionImagePrint();
		void setActionImageErase();

		void setActionCutEnabled();
		void setActionCopyEnabled();
		void setActionPasteEnabled();
		//END Set action's value

		void subscribeTemplate();
		void fontinst();

	private:
		KKDDoc* m_doc;
		KKDView* m_view;

		QStringList m_strlActions;

		QString m_filename;

		bool checkChangedAndSaved();
		void setEditActionEnabled();
		void resetCaption();
	};
}

#endif /* _KKDWIDGET_H_ */
