
#ifndef _config_parameters_h_
#define _config_parameters_h_

#include <qstring.h>

/*!
    Structure holding configuration parameters.
    It loads configuration from config file, or from defaults if it doesnt exist, when constructor is called.
    It saves configuration to config file only when save() is called, not on destructor !!!
*/
/// Configuration parameters
typedef class configParameters {

    public:

    /// save configuration to file
    void save();
    
    /// load configuration from file
    void load();
    
    /// constructor
    configParameters();
    
    /// copy constructor
    configParameters ( const configParameters& c ) {
        copy ( c );
    }
    
    /// copy-constructor routine, may be used explicitly
    void copy ( const configParameters& c );

    /// parameters structure
    struct {
        int videoQuality;
        int audioQuality;
        bool audioEnabled;
        QString workingDir;
        int fps;
        bool encodeOnTheFly;
        QString rmdPath;
        QString otherParams;
    } params;
};


#endif

