/*
    Copyright (C) 2008  Tim Fechtner < urwald at users dot sourceforge dot net >

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of
    the License or (at your option) version 3 or any later version
    accepted by the membership of KDE e.V. (or its successor approved
    by the membership of KDE e.V.), which shall act as a proxy
    defined in Section 14 of version 3 of the license.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "settings_stream_widget_connection.h"
#define AND  &&
#define OR  ||
#define NOT  !
#define EQUAL  ==

settings_stream_widget_connection::settings_stream_widget_connection(QWidget *parent)
  : QStackedWidget(parent)
{
  setupUi(this);

  // Set the history list. Doing this in the .ui file whould result in marking these
  // strings for translation - and that would be bad.
  QStringList predefinedUserAgentStrings;
  predefinedUserAgentStrings.append(QString("KRadioRipper"));
  predefinedUserAgentStrings.append(QString("Streamripper"));
  predefinedUserAgentStrings.append(QString("WinampMPEG/5.0"));
  predefinedUserAgentStrings.append(QString("Winamp/2.x"));
  predefinedUserAgentStrings.append(QString("FreeAmp/2.x"));
  predefinedUserAgentStrings.append(QString("XMMS/1.x"));
  predefinedUserAgentStrings.append(QString("UnknownPlayer/1.x"));
  predefinedUserAgentStrings.append(QString("IE 5.0"));
  predefinedUserAgentStrings.append(QString("iTunes/4.7 (Macintosh; N; PPC))"));
  predefinedUserAgentStrings.append(QString("RMA/1.0 (compatible; RealMedia))"));
  kcfg_advanced_userAgentString->setHistoryItems(predefinedUserAgentStrings);
}

// TODO nach 15 sec oder welcher Zeit auch immer sollte die Erkennung abgebrochen werden... Timeout!

settings_stream_widget_connection::~settings_stream_widget_connection()
{
  helper_disconnect_m_process_and_kill();  // make sure that m_process
  // stops emitting signals while we are yet destroing everything her.
  // I don't know why, but when we don't do this, the application
  // crashes with "signal 6/SIGABORT: pure virtual method called".
}

void settings_stream_widget_connection::helper_setServerUri_connectMProcess_startRecognization()
{
  m_process.setServerUri(kcfg_serverUri->text());
  connect(
    &m_process,
    SIGNAL(not_running()),
    this,
    SLOT(change_empty_user_visible_widgets_to__connection_failed()));
  connect(&m_process,
           SIGNAL(streamNameChanged(qlonglong, PropertyValue)),
           this,
           SLOT(setStreamName(qlonglong, PropertyValue)));
  connect(&m_process,
           SIGNAL(serverNameChanged(qlonglong, PropertyValue)),
           this,
           SLOT(setServerName(qlonglong, PropertyValue)));
  connect(&m_process,
           SIGNAL(bitrateChanged(qlonglong, PropertyValue)),
           this,
           SLOT(setBitrate(qlonglong, PropertyValue)));
  connect(&m_process,
           SIGNAL(metaIntervalChanged(qlonglong, PropertyValue)),
           this,
           SLOT(setMetaInterval(qlonglong, PropertyValue)));
  m_process.startStreamripper();
}

void settings_stream_widget_connection::helper_disconnect_m_process_and_kill()
{
  disconnect(
    &m_process,
    SIGNAL(not_running()),
    this,
    SLOT(change_empty_user_visible_widgets_to__connection_failed()));
  disconnect(&m_process,
              SIGNAL(streamNameChanged(qlonglong, PropertyValue)),
              this,
              SLOT(setStreamName(qlonglong, PropertyValue)));
  disconnect(&m_process,
              SIGNAL(serverNameChanged(qlonglong, PropertyValue)),
              this,
              SLOT(setServerName(qlonglong, PropertyValue)));
  disconnect(&m_process,
              SIGNAL(bitrateChanged(qlonglong, PropertyValue)),
              this,
              SLOT(setBitrate(qlonglong, PropertyValue)));
  disconnect(&m_process,
              SIGNAL(metaIntervalChanged(qlonglong, PropertyValue)),
              this,
              SLOT(setMetaInterval(qlonglong, PropertyValue)));
  m_process.abortStreamripper();
}

QString settings_stream_widget_connection::helper_qstring_localized__recognizing()
{
  return i18nc("@item This is displayed in the stream settings dialog for the stream info after "
                 "entering a new URI",
               "Recognizing...");
}

void settings_stream_widget_connection::delete_old_streamInfo_and_start_recognization()
{
  helper_disconnect_m_process_and_kill();

  // delete the values in the config system and update the GUI
  kcfg_info_serverName->setText(ripping::default_value_of_serverName());
  kcfg_info_streamName->setText(ripping::default_value_of_streamName());
  kcfg_info_bitrate->setValue(ripping::default_value_of_bitrate());
  kcfg_info_metaInterval->setValue(ripping::default_value_of_metaInterval());

  info_serverName->setText(helper_qstring_localized__recognizing());
  info_streamName->setText(helper_qstring_localized__recognizing());
  info_bitrate->setText(helper_qstring_localized__recognizing());
  info_metaInterval->setText(helper_qstring_localized__recognizing());
  info_serverName->setEnabled(false);
  info_streamName->setEnabled(false);
  info_bitrate->setEnabled(false);
  info_metaInterval->setEnabled(false);

  helper_setServerUri_connectMProcess_startRecognization();
}

// TODO what does this class, if the streamripper-binary isn't found?

void settings_stream_widget_connection::load_info_from_kcfg_and_start_recognization()
{
  connect(kcfg_serverUri, SIGNAL(textChanged(const QString&)), this,
           SLOT(delete_old_streamInfo_and_start_recognization()));

  /* This "connect" must be done here and can not be done in the constructor.

     Imagine that it would be done in the constructor. The widget is constructed
     and the signal is connected. Than, the widget is added to a KConfigDialog;
     and this KConfigDialog will set the text field kcfg_serverUri to a value
     taken from a config file. And than, delete_old_streamInfo_and_start_recognization()
     would be called. But we don't want the old info be deleted - when there's no
     internet connection at this moment, the fields would be deleted :-(And exactly
     that do we want to prevent.
  */

  helper_disconnect_m_process_and_kill();  // just to be sure...

  PropertyValue temp_serverName = ripping::formatedServerName(kcfg_info_serverName->text());
  if (temp_serverName.type != PropertyValue::value) {
    temp_serverName.formatedValue = helper_qstring_localized__recognizing();
  };
  setServerName(0, temp_serverName);

  PropertyValue temp_streamName = ripping::formatedStreamName(kcfg_info_streamName->text());
  if (temp_streamName.type != PropertyValue::value) {
    temp_streamName.formatedValue = helper_qstring_localized__recognizing();
  };
  setStreamName(0, temp_streamName);

  PropertyValue temp_bitrate = ripping::formatedBitrate(kcfg_info_bitrate->value());
  if (temp_bitrate.type != PropertyValue::value) {
    temp_bitrate.formatedValue = helper_qstring_localized__recognizing();
  };
  setBitrate(0, temp_bitrate);

  PropertyValue temp_metaInterval =
    ripping::formatedMetaInterval(kcfg_info_metaInterval->value());
  if (temp_metaInterval.type != PropertyValue::value) {
    temp_metaInterval.formatedValue = helper_qstring_localized__recognizing();
  };
  setMetaInterval(0, temp_metaInterval);

  helper_setServerUri_connectMProcess_startRecognization();
}

void settings_stream_widget_connection::setStreamName(qlonglong index, PropertyValue streamName)
{
  kcfg_info_streamName->setText(streamName.internalValue.toString());
  info_streamName->setText(streamName.formatedValue);
  if (streamName.type == PropertyValue::value) {
    info_streamName->setEnabled(true);
  } else {
    info_streamName->setEnabled(false);
  };
}

void settings_stream_widget_connection::setServerName(qlonglong index, PropertyValue serverName)
{
  kcfg_info_serverName->setText(serverName.internalValue.toString());
  info_serverName->setText(serverName.formatedValue);
  if (serverName.type == PropertyValue::value) {
    info_serverName->setEnabled(true);
  } else {
    info_serverName->setEnabled(false);
  };
}

void settings_stream_widget_connection::setBitrate(qlonglong index, PropertyValue bitrate)
{
  kcfg_info_bitrate->setValue(bitrate.internalValue.toLongLong());
  info_bitrate->setText(bitrate.formatedValue);
  if (bitrate.type == PropertyValue::value) {
    info_bitrate->setEnabled(true);
  } else {
    info_bitrate->setEnabled(false);
  };
}

void settings_stream_widget_connection::setMetaInterval(qlonglong index,
                                                         PropertyValue metaInterval)
{
  kcfg_info_metaInterval->setValue(metaInterval.internalValue.toLongLong());
  info_metaInterval->setText(metaInterval.formatedValue);
  if (metaInterval.type == PropertyValue::value) {
    info_metaInterval->setEnabled(true);
  } else {
    info_metaInterval->setEnabled(false);
  };
}

void settings_stream_widget_connection::change_empty_user_visible_widgets_to__connection_failed()
{
  // if values hasn't been recognized (that's different from "error during recognization"!)
  if (ripping::formatedServerName(kcfg_info_serverName->text()).type == PropertyValue::unset) {
    info_serverName->setText(i18nc("@item This is displayed in the stream settings dialog for "
                                       "the stream info after entering a new URI",
                                   "Connection failed."));
  };
  if (ripping::formatedServerName(kcfg_info_streamName->text()).type == PropertyValue::unset) {
    info_streamName->setText(i18nc("@item This is displayed in the stream settings dialog for "
                                       "the stream info after entering a new URI",
                                   "Connection failed."));
  };
  if (ripping::formatedBitrate(kcfg_info_bitrate->value()).type == PropertyValue::unset) {
    info_bitrate->setText(i18nc("@item This is displayed in the stream settings dialog for "
                                       "the stream info after entering a new URI",
                                "Connection failed."));
  };
  if (ripping::formatedMetaInterval(kcfg_info_metaInterval->value()).type ==
       PropertyValue::unset) {
    info_metaInterval->setText(i18nc("@item This is displayed in the stream settings dialog for "
                                       "the stream info after entering a new URI",
                                     "Connection failed."));
  };
}
