/*
    Copyright (C) 2008  Tim Fechtner < urwald at users dot sourceforge dot net >

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of
    the License or (at your option) version 3 or any later version
    accepted by the membership of KDE e.V. (or its successor approved
    by the membership of KDE e.V.), which shall act as a proxy
    defined in Section 14 of version 3 of the license.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef SETTINGS_STREAM_DIALOG_H
#define SETTINGS_STREAM_DIALOG_H

#include "settings_stream.h"
#include <KConfigDialog>

/** \brief This class provides a complete config dialog for settings_stream.
*
*   The dialog uses the widgets settings_stream_widget_connection,
*   settings_stream_widget_saving and settings_stream_widget_splitting.
*
*   The class inherits \e public from <tt>KConfigDialog</tt> - this way you can use the functions
*   from <tt>KConfigDialog</tt>. But be carefull: Use only the functions from which you know exactly
*   what they do. */
class settings_stream_dialog : public KConfigDialog
{

  Q_OBJECT

  public:
    /** The constructor.
        @param parent Pass a <tt>QWidget</tt> as parent - the dialog will be
                      centered to this widget.
        @param name Set a name for this object. You can read the name later using the
                    property <tt>objectName</tt> (class <tt>QObject</tt>).
        @param config Set the settings_stream object which will be used for the dialog. */
    settings_stream_dialog(QWidget * parent, const QString name, settings_stream * config);
    /** The destructor. */
    virtual ~settings_stream_dialog();
};

#endif
