/*
    Copyright (C) 2008  Tim Fechtner < urwald at users dot sourceforge dot net >

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of
    the License or (at your option) version 3 or any later version
    accepted by the membership of KDE e.V. (or its successor approved
    by the membership of KDE e.V.), which shall act as a proxy
    defined in Section 14 of version 3 of the license.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "settings_stream_dialog.h"
#include "settings_stream_widget_connection.h"
#include "settings_stream_widget_splitting.h"
#include "settings_stream_widget_saving.h"

settings_stream_dialog::settings_stream_dialog(QWidget * parent,
                                                const QString name,
                                                settings_stream * config)
  : KConfigDialog(parent, name, config)
{
  // variables
  QPointer<settings_stream_widget_connection> m_settings_stream_widget_connection;

  // code
  m_settings_stream_widget_connection = new settings_stream_widget_connection(this);
  addPage(m_settings_stream_widget_connection,
          i18nc("@title of a page in the configuration dialog", "Connection"),
          "settings_stream_widget_connection");
  m_settings_stream_widget_connection->
    load_info_from_kcfg_and_start_recognization();

  addPage(new settings_stream_widget_splitting(this),
          i18nc("@title of a page in the configuration dialog", "Splitting"),
          "settings_stream_widget_splitting");

  addPage(new settings_stream_widget_saving(this),
          i18nc("@title of a page in the configuration dialog", "Saving"),
          "settings_stream_widget_saving");

  setModal(true);
  showButton(KDialog::Help, false);  // TODO make a help available!
}

settings_stream_dialog::~settings_stream_dialog()
{
}
