/*
    Copyright (C) 2008  Tim Fechtner < urwald at users dot sourceforge dot net >

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of
    the License or (at your option) version 3 or any later version
    accepted by the membership of KDE e.V. (or its successor approved
    by the membership of KDE e.V.), which shall act as a proxy
    defined in Section 14 of version 3 of the license.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "get_streamripper_version.h"
#include "klocale.h"
#include <KDebug>
#include <QTimer>
#define AND  &&
#define OR  ||
#define NOT  !
#define EQUAL  ==

get_streamripper_version::get_streamripper_version(const QPointer<QObject> parent)
  : streamripper_base(parent)
{
  QObject::connect(&m_process,
                    SIGNAL(stateChanged(QProcess::ProcessState)),
                    this,
                    SLOT(binaryStateChange(QProcess::ProcessState)));
}

get_streamripper_version::~get_streamripper_version()
{
}

QString get_streamripper_version::streamripperCommand() const
{
  return internal_streamripperCommand;
}

void get_streamripper_version::setStreamripperCommand(const QString value)
{
  if (value != internal_streamripperCommand) {
    internal_streamripperCommand = value;
    abortStreamripper();
    stillSignalExpected = true;
    startStreamripper();
  };
}

QStringList get_streamripper_version::parameterList() const
{
  // variables
  QStringList parameters;

  //code
  parameters.append(QString("-v"));
  return parameters;
}

void get_streamripper_version::interpretate_console_output (QStringList &stringList)
{
  //variables
  QString myString;
  //VersionNumber myVersionNumber;

  // code
  myString = stringList.takeFirst().simplified();  // first line with simplified whitespaces
  if (myString.toLower().startsWith(QString("streamripper"))) {

    myString.remove(0, 12);
    myString = myString.trimmed();  // remove whitespace at the start and the end

    PropertyValue myPropertyValue;  // creates a new PropertyValue variable with default values.
    myPropertyValue.internalValue.setValue(myString);
    myPropertyValue.type = PropertyValue::value;
    myPropertyValue.formatedValue = myString;
    // no toolTip/whatsThis nessasary!

    emit versionNumberDeterminated(myPropertyValue);

    stillSignalExpected = false;
  };
  QTimer::singleShot(0, this, SLOT(abortStreamripper()));
}

void get_streamripper_version::binaryStateChange(QProcess::ProcessState newState)
{
  if (newState == QProcess::NotRunning) {
    if (stillSignalExpected) {
      // make a PropertyValue of type "VersionNumber" which is unset and emit it as signal...
      PropertyValue myPropertyValue;  // creates a new PropertyValue variable with default values.
      myPropertyValue.type = PropertyValue::error;
      myPropertyValue.formatedValue = i18nc("@item", "Streamripper not found.");
      myPropertyValue.toolTip = i18nc(
        "@info:tooltip",
        "Streamripper could not be invoced or did not return a version number.");
      myPropertyValue.whatsThis = i18nc(
        "@info:whatsthis",
        "The specified command for Streamripper could either not be invoced (because "
          "it does not exist or because you do not have execution rights) or it did "
          "not return a proper version number.");
      emit versionNumberDeterminated(myPropertyValue);
      stillSignalExpected = false;
    };
  };
}
