/*
    Copyright (C) 2008  Tim Fechtner < urwald at users dot sourceforge dot net >

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of
    the License or (at your option) version 3 or any later version
    accepted by the membership of KDE e.V. (or its successor approved
    by the membership of KDE e.V.), which shall act as a proxy
    defined in Section 14 of version 3 of the license.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "get_stream_info.h"
#define AND  &&
#define OR  ||
#define NOT  !
#define EQUAL  ==

get_stream_info::get_stream_info(const QPointer<QObject> parent) : ripping(parent)
{
}

get_stream_info::~get_stream_info()
{
}

QString get_stream_info::serverUri() const
{
  return internal_serverUri;
}

void get_stream_info::setServerUri(const QString value)
{
  if (NOT (value EQUAL internal_serverUri)) {
    abortStreamripper();
    internal_serverUri=value;
    resetStreamripperProperties();
  };
}

QStringList get_stream_info::parameterList() const
{
  // variables
  QStringList parameters;

  //code
  // calculate all parameters
  parameters += ripping::parameterList();

  parameters.append(QString("-M"));
  parameters.append(QString("0"));  // stop after the stream starts

  parameters.append(QString("-A"));  // don't write any files...

  return parameters;
}
