/*
    Copyright (C) 2008-2009  Tim Fechtner < urwald at users dot sourceforge dot net >

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of
    the License or (at your option) version 3 or any later version
    accepted by the membership of KDE e.V. (or its successor approved
    by the membership of KDE e.V.), which shall act as a proxy
    defined in Section 14 of version 3 of the license.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef STATIONDIRECTORYTREE_H
#define STATIONDIRECTORYTREE_H

#include <QTreeWidget>
#include <KIcon>
class streamDirectoryService;
/* This must be a forward declaration and not an #include, because
 * streamDirectoryService and stationDirectoryTree depend on each other.
 * So, here make a forward declaration, and in streamdirectoryservice.h
 * we can include THIS file. */

/** \brief A widget which provides a stream directory.
*
* To access stream directories in the internet, this widget uses plugins. Plugins
* are objects which are derived from streamDirectoryService. To use them,
* create such an object, make your settings, and than register it with
* registerPlugin(). */
class stationDirectoryTree : public QTreeWidget
{

  Q_OBJECT

  friend class streamDirectoryService;  // TODO lasse das nur für die nötigsten Funktionen gelten

  public:
    /** Constructor of the class.
    * @param parent Sets the parent widget of this object.
    * @param genreIconFileName See #genreIcon for details. */
    explicit stationDirectoryTree(QWidget *parent, const QString & genreIconFileName = QString());
    /** The desctructor. */
    virtual ~stationDirectoryTree();
    /** Uses the specified object as plugin.
    *
    * If the specified object is already registered as plugin at another widget,
    * it will be unregistered there and than registered here.
    *
    * @param plugin The object to be registered as plugin. */
    void registerPlugin(streamDirectoryService *plugin);

  private:
    /** Adds a stream with the specified values. Is provides for use from the friend
    class streamDirectoryService. TODO Parameter dokumentieren. */
    void addStreamToWidget(streamDirectoryService *plugin,
                           const QString & genre,
                           const QString & streamName,
                           const quint64 bitrate,
                           const QString & currentlyPlaying = QString());
    /** Removes all streams that have been added by the specified plugin.
    * Is provides for use from the friend class streamDirectoryService.
    * @param plugin the plugin */
    void removeAllStreamsOfThisService(const streamDirectoryService *plugin);
    /** Holds the icon the is used for the genres. It is set in the constructor and later
    * can't be changed anymore.
    *
    * The constructor determinates the size of this icon (based on the font size used in the
    * list). */
    KIcon genreIcon;

};

#endif
