#!/bin/sh
# Runs the krazy2 codechecker (verbose) on all files and saves the result at apidoc/codecheck.html
SCRIPTDIR=`pwd`


echo "Calling krazy2all"
export PATH=$PATH:/usr/local/Krazy2/bin
cd ${SCRIPTDIR}/../
# The value tipsandthis could be added in the next line to the --extra parameter!
krazy2all --extra contractions,defines,kdebug,multiclasses,null,qenums,style --export html --brief --cms --quiet > ${SCRIPTDIR}/../apidoc/codecheck.html
echo
echo "Done calling krazy2all"
echo "Calling flawfinder"
flawfinder --quiet --html ${SCRIPTDIR}/../ > ${SCRIPTDIR}/../apidoc/flawfinder.html
echo "Done calling flawfinder"