//
// C++ Interface: kpogrecontroller
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPOGRECONTROLLER_H
#define KPOGRECONTROLLER_H

#include <qobject.h>

// application specific includes
#include "kpogreview.h"
#include "kpgactionsstates.h"

// Forward references
class KActionCollection;
class KPoGreView;
class KPoGreComboAction;
class KPGSearchDialog;


/**
  *  Respond to user KActions
  *
  *	@author Lumir Vanek <lvanek@users.sourceforge.net>
  */
class KPoGreController : public QObject
{
	Q_OBJECT
public:
    KPoGreController(KPoGreView *);
    ~KPoGreController();

	// Initializes the KActions of the application
	void initActions(KActionCollection *);
	
protected:
	KPoGreView * m_pView;
	
	// For searching in m_pView->m_pViewTree
	KPGSearchDialog* m_pDlgSearch;
	
	// For searching in SQL Query editor
	QStringList m_listOfQuerySearchHistory;

	// For replacing in data tables and result tables
	//QStringList m_listOfQueryReplacementHistory;
	
	// For searching in data tables and result tables
	//QStringList m_listOfResultQuerySearchHistory;
	
	//-------------------------------------------------------------------------
    //
    // KAction pointers to enable/disable actions
    //
    //-------------------------------------------------------------------------
    
    // File actions
    KAction *m_pActFileExportResult;
    KAction* m_pActFileNewWindow;
    KAction* m_pActFileNew;
    KAction* m_pActFileOpen;
    KRecentFilesAction* m_pActFileOpenRecent;
    KAction* m_pActFileClose;
    KAction* m_pActFileQuit;
    
    // Edit actions
	KAction* m_pActEditFindInTree;
	KAction* m_pActEditFindNextInTree;
					
	// View actions
	KToggleAction* m_pActViewToolBar;
    KToggleAction* m_pActViewStatusBar;
    KAction* m_pActFolderRefresh;
       
    // Database actions
    KAction* m_pActServerRegister;
    KAction* m_pActDatabaseConnect;
    KAction* m_pActDatabaseDisconnect;
    KAction* m_pActDatabaseWizard;
    
	KPoGreComboAction* m_pActPathCombo;
	
public slots:
    //-------------------------------------------------------------------------
    //
    // Main menu actions
    //
    //-------------------------------------------------------------------------
    
    //--- File main menu actions
    void slotFileNewWindow();
    void slotFileNew();
    void slotFileOpen();
    void slotFileOpenRecent(const KURL& url);
    void slotExportResult();
    void slotFileClose();
    void slotFileQuit();
    
	//--- Edit main menu actions
	void slotEditFindInTree();
    void slotEditFindNextInTree();
        		
    //--- Settings main menu actions
	void slotViewToolBar();
    void slotViewStatusBar();
    
	//--- Database main menu actions
    void slotDatabaseConnect();
	void slotDatabaseDisconnect();
    void slotDatabaseWizard();
    
    //-------------------------------------------------------------------------
    //
    // Object menu actions fired from left tree view, when user right-click on object 
    //
    //-------------------------------------------------------------------------
		
	//--- Server related menu actions	
	void slotReloadServerConfig();
	void slotRotateServerLogFile();
		
	//--- Database related menu actions
	void slotCreateDatabase();
	void slotDropDatabase();
    void slotAnalyseDatabase();
    void slotReindexDatabase();
    void slotSetOwnerDatabase();
    void slotGrantPrivilegesDatabase();
    void slotRevokePrivilegesDatabase();
    void slotDumpDatabase();
    void slotRestoreDatabase();
    void slotDisconnectDatabase();
		
    //--- Schema related menu actions
	void slotCreateSchema();
	void slotDropSchema();
	void slotModifySchema();
    void slotSetOwnerSchema();
    void slotGrantPrivilegesSchema();
    void slotRevokePrivilegesSchema();
		
    //--- Table related menu actions
    void slotCreateTable();
	void slotDropTable();
    void slotRenameTable();
    void slotAnalyseTable();
    void slotVacuumTable();
    void slotReindexTable();
    void slotSetClusterOnTable();
    void slotSetWithoutClusterTable();
    void slotClusterTable();
    void slotCopyFromTable();
    void slotCopyToTable();
    void slotSetOwnerTable();
    void slotGrantPrivilegesTable();
    void slotRevokePrivilegesTable();
    void slotSetTablespaceTable();
    void slotSetWithoutOIDsTable();
    void slotEditTableContent();
    void slotQueryTable();
    
	//--- View related menu actions
    void slotCreateView();
	void slotDropView();
	void slotModifyView();
	void slotQueryView();
    void slotGrantPrivilegesView();
    void slotRevokePrivilegesView();
		    
    //--- Tablespaces related menu actions
    void slotCreateTablespace();
    void slotDropTablespace();
    void slotRenameTablespace();
    void slotSetOwnerTablespace();
    void slotGrantPrivilegesTablespace();
    void slotRevokePrivilegesTablespace();
    
    //--- User related menu actions
    void slotCreateUser();
	void slotDropUser();
	void slotModifyUser();
				
	//--- Group related menu actions
	void slotCreateGroup();
	void slotDropGroup();
	void slotModifyGroup();
        
    //--- Language related menu actions
    void slotCreateLanguage();
    void slotDropLanguage();
    void slotModifyLanguage();
    void slotGrantPrivilegesLanguage();
    void slotRevokePrivilegesLanguage();
    
    //--- Domain related menu actions 
    void slotCreateDomain();
    void slotDropDomain();
    void slotSetDomainNull();
    void slotSetDomainDefault();
    void slotDropDomainDefault();
    void slotSetOwnerDomain();
    
    //--- Domain constraint related menu actions
    void slotCreateDomainConstraint();
    void slotDropDomainConstraint();
    
    //--- Function related menu actions
    void slotCreateFunction();
    void slotDropFunction();
    void slotRenameFunction();
    void slotModifyFunction();
    void slotGrantPrivilegesFunction();
    void slotRevokePrivilegesFunction();
    void slotExecuteFunction();
    void slotDebugFunction();
    
    //--- Sequence related menu actions
    void slotCreateSequence();
    void slotDropSequence();
    void slotModifySequence();
    void slotGrantPrivilegesSequence();
    void slotRevokePrivilegesSequence();
        
    //--- Column related menu actions
    void slotCreateColumn();
    void slotDropColumn();
    void slotRenameColumn();
    void slotSetColumnNull();
    void slotSetColumnDefault();
    void slotDropColumnDefault();
    void slotChangeColumnType();
    void slotSetColumnStorage();
    void slotSetColumnStatistisc();
    
    //--- Constraint related menu actions
    void slotCreateConstraint();
    void slotDropConstraint();
    
    //--- Index related menu actions
    void slotCreateIndex();
    void slotDropIndex();
    void slotRenameIndex();
    void slotReindexIndex();
    void slotSetOwnerIndex();
    void slotSetTablespaceIndex();
        
    //--- Rule related menu actions
    void slotCreateRule();
    void slotDropRule();
    
    //--- Trigger related menu actions
    void slotCreateTrigger();
    void slotDropTrigger();
    void slotEnableTrigger();
    void slotRenameTrigger();
    
    //--- Type related menu actions
    void slotCreateBaseType();
    void slotCreateCompositeType();
    void slotDropType();
    void slotSetOwnerType();
    
    //--- Common menu actions
	void slotSetDescription();
	
    //-------------------------------------------------------------------------
    //
    // Other slots
    //
    //-------------------------------------------------------------------------
public slots:
    
    // Refresh selected item - F5
	void slotRefresh();
	
	// Fired, when user select path i Path bar
	void slotPathSelected( const QString & szPath );
	
	// Request to clear Path bar
	void slotPathClear();
	
    // Called when user press Bookmarks Button
	void slotBookmarksButtonPressed();
	
	// Called, when user change selection in tree view
	void slotSelectionChanged( const KPGTreeItem::eNodeType, KPGTreeItem *);
				
	// Display status line message
	void slotStatusMsg(const QString &);
	
	// Called, when document is modified. Enable Save button. */
	void slotDocumentModified();
	
public:
	bool isActViewToolBarChecked() const { return m_pActViewToolBar->isChecked(); }
	bool isActViewStatusBarChecked() const { return m_pActViewStatusBar->isChecked(); }
	KRecentFilesAction* getRecentFilesAction() const { return m_pActFileOpenRecent; }
	void setActViewToolBarChecked(bool c) const { m_pActViewToolBar->setChecked(c); }
	void setActViewStatusBarChecked(bool c) const { m_pActViewStatusBar->setChecked(c); }
};

#endif
