//
// C++ Interface: kpogrecomboaction
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPOGRECOMBOACTION_H
#define KPOGRECOMBOACTION_H

#include <kaction.h>
#include <qlabel.h>

class QComboBox;

/**
A Path bar

@author Lumir Vanek
*/

class KPoGreComboAction : public KAction
{
Q_OBJECT
public:
    KPoGreComboAction(const QString& text, int accel, const QObject *receiver, const char *member, QObject* parent, const char* name);
    ~KPoGreComboAction();

		virtual int plug(QWidget *w, int index = -1);

    virtual void unplug(QWidget *w);

    /** Returns the text from the combobox' editline (@ref QComboBox::currentText). */
    QString currentText() const;

    /** Returns the current pixmap or 0, if there isn't any (see @ref QComboBox::pixmap). */
    const QPixmap * currentPixmap() const;

    /**
     * Inserts the given item as the first.
     * Deletes the old entry, if the item was already in the list.
     */
    void insertItem( const QPixmap & pixmap, const QString & text );

    /** Tries to remove the item with the given text. */
    void removeItem( const QString & text );

    /** returns combo box */
    QComboBox *comboBox();

public slots:
    /** Clears the whole combobox using @ref QComboBox::clear. */
    void slotClear();
    
    /** Clears the combobox' editline. */
    void slotClearEdit();
    
    /** Gives focus to the combobox' editline. */
    void slotFocusEdit();

protected:
    /**
     * Tries to find an item with the given text. If it finds it,
     * the items id is returned, otherwise -1.
     */
    virtual int findItem( const QString & text );

private:
    const QObject *m_receiver;
    const char *m_member;
    QComboBox * m_pCombo;
};


class ToolbarLabel : public QLabel
{
    Q_OBJECT
public:
    ToolbarLabel( const QString & text );
};


#endif
