//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcreatedomainwidget1.h"


// include files for KDE
#include <kdebug.h>
#include <klocale.h>
#include <klineedit.h>
#include <kcombobox.h> 


// application specific includes
#include "../DbObjects/kpgdatabase.h"
#include "../kpgutil.h"


KPGCreateDomainWidget1::KPGCreateDomainWidget1(QWidget *parent, const char *name, QPtrList<QListViewItem> & listOfSchemas)
 : KPGCreateDomainWidget1Base(parent, name)
{
	int iCurrentItem = -1;
	int i = 0;  
	for(QListViewItem *pSchema = listOfSchemas.first(); pSchema; pSchema = listOfSchemas.next())
		{
		m_pComboBoxSchema->insertItem(* pSchema->pixmap(0), pSchema->text(0));
		
		if(pSchema->text(0) == "public")
			iCurrentItem = i;
			
		++i;
		}
		
	if(iCurrentItem >= 0)
		m_pComboBoxSchema->setCurrentItem(iCurrentItem);
	
	m_pLineEditDomainName->setFocus();
  
}


KPGCreateDomainWidget1::~KPGCreateDomainWidget1()
{
}


void KPGCreateDomainWidget1::slotDomainNameChanged(const QString &strText)
{
  	emit sigEnableNextButton(! strText.isEmpty() );
}


// Return part of SQL statement for CREATE DOMAIN
const QString KPGCreateDomainWidget1::getSQL() const
{
	QString strSql("CREATE DOMAIN ");
	
	strSql.append(KPGUtil::fullyQualifiedName(m_pComboBoxSchema->currentText(), m_pLineEditDomainName->text()));
	strSql.append(" AS ");
			
	return strSql;
}

#include "kpgcreatedomainwidget1.moc"
