//
// C++ Implementation: kpgtablecolumnsfolderproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgtablecolumnsfolderproppage.h"

#include <qtable.h>

#include <klocale.h>

#include "../kpgutil.h"
#include "../DbObjects/kpgtablecolumnsfolder.h"

KPGTableColumnsFolderPropPage::KPGTableColumnsFolderPropPage(QWidget* parent, KPGTableColumnsFolder *pTableColumnsFolder)
	: KPGPropertyPage(parent, "KPGTableColumnsFolderPropPage")
{
	m_pTableColumnsFolder = pTableColumnsFolder;
	displayProperties();
}


KPGTableColumnsFolderPropPage::~KPGTableColumnsFolderPropPage()
{
}

void KPGTableColumnsFolderPropPage::displayProperties()
{
	setLabelText(i18n("Columns &list:"));
		
	// field names
  	QHeader* pHeader = m_pTableItems->horizontalHeader();

  	int nCol = 0;
	pHeader->setLabel(nCol++, i18n("Name"));
	pHeader->setLabel(nCol++, i18n("Type"));
	pHeader->setLabel(nCol++, i18n("Type length"));
	pHeader->setLabel(nCol++, i18n("Description"));
	pHeader->setLabel(nCol++, i18n("Statistics target"));
	pHeader->setLabel(nCol++, i18n("Attribute number"));
	pHeader->setLabel(nCol++, i18n("Dimensions"));
	pHeader->setLabel(nCol++, i18n("Type mode"));
	pHeader->setLabel(nCol++, i18n("By value"));
	pHeader->setLabel(nCol++, i18n("Not null"));
	pHeader->setLabel(nCol++, i18n("Has default"));
	pHeader->setLabel(nCol++, i18n("Is dropped"));
	pHeader->setLabel(nCol++, i18n("Is local"));
	pHeader->setLabel(nCol++, i18n("Storage"));
	pHeader->setLabel(nCol++, i18n("Inherited count"));
	pHeader->setLabel(nCol++, i18n("Default value"));
	pHeader->setLabel(nCol++, i18n("Namespace"));

	KPGUtil::fillPropertiesTable(m_pTableColumnsFolder->resultColumns(), m_pTableItems);
}



