//
// C++ Implementation: kpgrulesfolderproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgrulesfolderproppage.h"


#include <qtable.h>

// include files for KDE
#include <kdebug.h>
#include <klocale.h>

#include "../kpgutil.h"
#include "../DbObjects/kpgrulesfolder.h"


KPGRulesFolderPropPage::KPGRulesFolderPropPage(QWidget* parent, KPGRulesFolder * pRulesFolder)
	: KPGPropertyPage(parent, "KPGRulesFolderPropPage")
{
	m_pRulesFolder = pRulesFolder;
	displayProperties();
}

KPGRulesFolderPropPage::~KPGRulesFolderPropPage()
{
}

void KPGRulesFolderPropPage::displayProperties()
{
	setLabelText(i18n("Rules &list:"));
	
	QHeader* pHeader = m_pTableItems->horizontalHeader();

	int nCol = 0;
	pHeader->setLabel(nCol++, i18n("Name"));
	pHeader->setLabel(nCol++, i18n("Description"));
	pHeader->setLabel(nCol++, i18n("Is instead"));
	pHeader->setLabel(nCol++, i18n("Event type"));
	pHeader->setLabel(nCol++, i18n("Qualifying condition"));
	pHeader->setLabel(nCol++, i18n("Namespace"));
	
	KPGUtil::fillPropertiesTable(m_pRulesFolder->resultRules(), m_pTableItems);
}
