//
// C++ Implementation: kpgoperatorclass
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgoperatorclass.h"

// include files for KDE
#include <kdebug.h>
#include <klocale.h>

#include "kpgoperatorclassesfolder.h"


KPGOperatorClass::KPGOperatorClass(KPGOperatorClassesFolder *parent, const QString name, pqxx::oid _oid)
  : KPGObject(parent, name, _oid)
{
    setPixmap(0, *m_pIconOperatorClass);
}

KPGOperatorClass::KPGOperatorClass(KPGOperatorClassesFolder *parent, KPGOperatorClass *after, const QString name, pqxx::oid _oid)
  : KPGObject(parent, after, name, _oid)
{
    setPixmap(0, *m_pIconOperatorClass);
}


KPGOperatorClass::~KPGOperatorClass()
{
}


void KPGOperatorClass::setProperties(const pqxx::result::tuple &pqxxTuple)
{
    pqxxTuple["opcdefault"].to(m_bIsDefault);
    pqxxTuple["opcintype"].to(m_oidDataType);
    pqxxTuple["opckeytype"].to(m_oidKeyType);
                
	m_strDataType = pqxxTuple["intypename"].c_str();
	m_strKeyType = pqxxTuple["keytypename"].c_str();
	m_strAccessMethodName = pqxxTuple["amname"].c_str();
	m_strOwner = pqxxTuple["opowner"].c_str();
}

