//
// C++ Implementation: kpglanguage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpglanguage.h"

// include files for KDE
#include <kiconloader.h>
#include <kdebug.h>
#include <klocale.h>


#include "../kpglinklabel.h"
#include "kpglanguagesfolder.h"
#include "kpgdatabase.h"
#include "../kpgutil.h"


KPGLanguage::KPGLanguage(KPGLanguagesFolder *parent, const QString name, pqxx::oid _oid)
  : KPGObject(parent, name, _oid)
{
  	setPixmap(0, *m_pIconLanguage);
}

KPGLanguage::KPGLanguage(KPGLanguagesFolder *parent, KPGLanguage *after, const QString name, pqxx::oid _oid)
  : KPGObject(parent, after, name, _oid)
{
  setPixmap(0, *m_pIconLanguage);
}

KPGLanguage::~KPGLanguage()
{
}

void KPGLanguage::setProperties(const pqxx::result::tuple &pqxxTuple)
{
	pqxxTuple["lanpltrusted"].to(m_bIsTrusted);
    pqxxTuple["procoid"].to(m_oidLanguageProc);
    pqxxTuple["validoid"].to(m_oidValidatorProc);
            	
    m_strACL = pqxxTuple["lanacl"].c_str();
	m_strLanguageProcName = pqxxTuple["langproc"].c_str();
	m_strValidatorProcName = pqxxTuple["langvalidator"].c_str();
}

// Refresh only language info, without childs objects
void KPGLanguage::refreshItem() throw(const KPGSqlException &)
{
    // Get pointer to server for version info
    //KPGDatabase *pDatabase = static_cast <KPGDatabase *> (parent()->parent());
    
    // obtain list of languages
    QString strQuery("SELECT lan.oid, lan.lanname, lanpltrusted, lanacl, hp.oid AS procoid, hp.proname as langproc, vp.oid AS validoid, vp.proname as langvalidator ");
    strQuery.append("FROM pg_catalog.pg_language lan ");
    strQuery.append("JOIN pg_catalog.pg_proc hp on hp.oid=lanplcallfoid ");
    strQuery.append("LEFT OUTER JOIN pg_catalog.pg_proc vp on vp.oid=lanvalidator ");
    
    strQuery.append("WHERE lan.oid = " + QString("%1").arg(m_oid));
        
    try
    {
        pqxx::result pqxxResultLanguages = connection()->runQuery(strQuery);
        
        if(pqxxResultLanguages.size() != 1)
        {
            kdError() << k_funcinfo "Expect one row in result !" <<  endl;
            return;
        }
        
        setProperties(pqxxResultLanguages[0]); 
    }
    catch (const std::exception &e)
    {
        kdError() << k_funcinfo << e.what() << endl;
        throw KPGSqlException(e.what(), strQuery);
    } 
}

