//
// C++ Implementation: kpgdomain
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgdomain.h"

// include files for KDE
#include <kiconloader.h>
#include <kdebug.h>
#include <klocale.h>

#include "kpgconnection.h"
#include "kpgdomainsfolder.h"
#include "kpgdomainconstraintsfolder.h"


KPGDomain::KPGDomain(KPGDomainsFolder *parent, const QString name, pqxx::oid _oid)
	: KPGObject(parent, name, _oid)
{
    setPixmap(0, *m_pIconDomain);
    m_pFolderConstraints = new KPGDomainConstraintsFolder(this);
}

KPGDomain::KPGDomain(KPGDomainsFolder *parent, KPGDomain *after, const QString name, pqxx::oid _oid)
	: KPGObject(parent, after, name, _oid)
{
    setPixmap(0, *m_pIconDomain);
    m_pFolderConstraints = new KPGDomainConstraintsFolder(this);
}

KPGDomain::~KPGDomain()
{
}

void KPGDomain::refresh() throw(const KPGSqlException &)
{
    m_pFolderConstraints->refresh(m_oid);
}

void KPGDomain::setProperties(const pqxx::result::tuple &pqxxTuple)
{
    pqxxTuple["basetypeoid"].to(m_oidBaseType);
    pqxxTuple["typlen"].to(m_iTypLen);
    pqxxTuple["typnotnull"].to(m_bNotNull);
    pqxxTuple["typndims"].to(m_iTypNDims);
                
	m_strDescription = pqxxTuple["description"].c_str();
	m_strBaseType = pqxxTuple["basetype"].c_str();
	m_strDefault = pqxxTuple["typdefault"].c_str(); 
	m_strTypDelim = pqxxTuple["typdelim"].c_str();
	m_strOwner = pqxxTuple["owner"].c_str();
}

void KPGDomain::refreshConstraints()
{
  m_pFolderConstraints->refresh(m_oid);
}


