# kourou - a launcher for Ubuntu MID
# (C) 2008 Canonical Ltd
# Author: Steve Kowalik <stevenk@ubuntu.com>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, version 3 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# FIXME:
# - Singleton stuff
# - Set background
# - Unknown icon instead of None?

import os, subprocess, gobject, gtk, gconf, hildondesktop, xdg.Menu
import xdg.IconTheme
import re

class Kourou(hildondesktop.HomeItem):
    def __init__(self):
        hildondesktop.HomeItem.__init__(self)
        self.categories = {}
        self.seen = []
        self.client = gconf.client_get_default()
        self.rootwin = self.get_root_window()
        menu = xdg.Menu.parse()
        scrolled_win = gtk.ScrolledWindow()
        scrolled_win.set_policy(gtk.POLICY_NEVER, gtk.POLICY_AUTOMATIC)
        iconview = gtk.IconView()
        self.model = gtk.ListStore(str, gtk.gdk.Pixbuf, str, str, str)
        iconview.set_model(self.model)
        iconview.set_text_column(False)
        iconview.set_pixbuf_column(True)
        iconview.set_selection_mode(gtk.SELECTION_SINGLE)
        bgcolour = gtk.gdk.Color("#000000")
        fgcolour = gtk.gdk.Color("#ffffff")
        iconview.modify_base(gtk.STATE_NORMAL, bgcolour)
        iconview.modify_text(gtk.STATE_NORMAL, fgcolour)
        iconview.connect("item-activated", self.on_select)
        iconview.connect("selection-changed", self.single_click_select)
        iconview.show()
        scrolled_win.add(iconview)
        scrolled_win.show()
        self.add(scrolled_win)
        self.parse_menus(menu)
        self.set_categories()
        self.populate_model(self.client)
        self.client.notify_add("/apps/marquee-plugins/active", \
            self.populate_model)

    def parse_menus(self, entry):
        if isinstance(entry, xdg.Menu.Menu):
            for submenu in entry.Entries:
                self.parse_menus(submenu)
        elif isinstance(entry, xdg.Menu.MenuEntry):
            dentry = entry.DesktopEntry
            dentry_name = dentry.getName()
            if dentry.getType() != "Application" or dentry.getNoDisplay() or \
                dentry.filename in self.seen:
                return
            if dentry.getOnlyShowIn():
                print dentry.filename, dentry.getName(), dentry.getOnlyShowIn()
                if "gnome" not in map(lambda x: x.lower(), dentry.getOnlyShowIn()):
                    return
            if dentry.getNotShowIn():
                print dentry.filename, dentry.getName(), dentry.getNotShowIn()
                if "gnome" in map(lambda x: x.lower(), dentry.getNotShowIn()):
                    return
            self.seen.append(dentry.filename)
            pixbuf = self.fetch_icon(dentry.getIcon(), "Human")
            if pixbuf is None:
                pixbuf = self.fetch_icon(dentry.getIcon(), "gnome")
            mapentry = [dentry_name, pixbuf, dentry.getExec(), \
                dentry.filename, dentry.getIcon()]
            for parent in entry.Parents:
                while parent.Parent.Parent != None:
                    parent = parent.Parent
                name = parent.getName()
                if self.categories.has_key(name):
                    self.categories[name].append(mapentry)
                else:
                    self.categories[name] = [mapentry]

    def set_categories(self):
        self.client.set_string("/apps/marquee-plugins/active", "Home")
        self.client.set_list("/apps/marquee-plugins/categories", \
            gconf.VALUE_STRING, self.categories.keys())

    def populate_model(self, client, *args, **kwargs):
        current_cat = client.get_string('/apps/marquee-plugins/active')
        self.model.clear()
        if current_cat == "All":
            for cat in self.categories.keys():
                if cat in ("Home", "Preferences"):
                    continue
                for entry in self.categories[cat]:
                    self.model.append(entry)
        else:
            for entry in self.categories[unicode(current_cat)]:
                self.model.append(entry)

    def fetch_icon(self, icon_name, theme):
        icon = xdg.IconTheme.getIconPath(icon_name, 64, theme, ['svg', \
            'png', 'xpm'])
        pixbuf = None
        if icon:
            pixbuf = gtk.gdk.pixbuf_new_from_file_at_size(icon, 64, 64)
        return pixbuf

    def single_click_select(self, iconview):
        path = iconview.get_selected_items()
        if len(path) == 1:
            self.on_select(iconview, path[0])

    def on_select(self, iconview, path):
        def desktop_escape(string):
            return '"' + re.sub(r'(["`$\\])', r'\\\1', string) + '"'

        def sub_desktop_codes(matcho, icon = "", tname = "", desktop = ""):
            code = matcho.group(0)
            # to pass a file or URL, but not used yet
            if code in ("%f", "%F", "%u", "%U"):
                return ""
            # deprecated, should be ignored
            elif code in ("%d", "%D", "%n", "%N", "%v", "%m"):
                return ""
            elif code == "%i":
                if icon == "":
                    return ""
                return "--icon " + desktop_escape(icon)
            elif code == "%c":
                return desktop_escape(tname)
            elif code == "%k":
                if desktop == "":
                    return ""
                return desktop_escape(desktop)
            elif code == "%%":
                return "%"
            # unknown code
            return ""

        self.busy_cursor()
        cmd = self.model[path][2]
        # replace desktop codes from the desktop entry spec with their
        # double-quoted values
        repl = lambda matcho: sub_desktop_codes(matcho, desktop = \
            self.model[path][3], icon = self.model[path][4])
        cmd = re.sub(r"%[a-zA-Z%]", repl, cmd)
        p = subprocess.Popen(cmd, shell=True)
        iconview.unselect_path(path)
        gobject.timeout_add(4000, self.normal_cursor)

    def normal_cursor(self):
        self.rootwin.set_cursor(gtk.gdk.Cursor(gtk.gdk.LEFT_PTR))

    def busy_cursor(self):
        self.rootwin.set_cursor(gtk.gdk.Cursor(gtk.gdk.WATCH))

def hd_plugin_get_objects():
    plugin = Kourou()
    return [plugin]

