/***************************************************************************
*   Copyright (C) 2007-2010 by Thomas Thelliez aka jblud                  *
*   Contact : <admin.kontrol@gmail.com>                                   *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as               *
*   published by the Free Software Foundation; either version 2.0 of      *
*   the License, or (at your option) any later version.                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
*   General Public License for more details.                              *
*                                                                         *
*   You should have received a copy of the GNU General Public             *
*   License along with this program; if not, write to                     *
*   the Free Software Foundation, Inc.,                                   *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
***************************************************************************/

#include "file_manager_server.h"

FileManagerServer::FileManagerServer(auth_server *file_tcp_server, QObject *parent)
    : tcp_server(file_tcp_server), QObject(parent)
{
#ifdef WIN32
    slash = QString("\\");
#else
    slash = QString("/");
#endif
    file_queue_list = new QMap<int,QString>;
}

/**
    Receive document from remote client.
*/
void FileManagerServer::received_stream_files_slot(QString message, int client_nbr)
{
    QByteArray file_array = QByteArray::fromBase64(message.toUtf8());
    if (file_queue_list->contains(client_nbr)) {
        QFile *file = new QFile(file_queue_list->value(client_nbr));
        if (file->open(QIODevice::WriteOnly)) {
            file->write(file_array);
            emit tell_client_transfer_state(1, client_nbr);
        }else {
            qDebug("File not opened");
            emit tell_client_transfer_state(0, client_nbr);
        }
        file->close();
        file_queue_list->remove(client_nbr);
    }
}

/**
    Send document to remote client.
*/
int FileManagerServer::send_document(QString name, QString path, int client_nbr)
{
    if (!tcp_server->client_list->contains(client_nbr))
        return 0;
    QString file_path = path + slash + name;
    QFile *file = new QFile(file_path);
    if (file->exists()) {
        if (file->open(QIODevice::ReadOnly)) {
            if (file->isReadable()) {
                while (!file->atEnd()) {
                    tcp_server->write_encrypted_data_to_socket(file->readAll().toBase64().data(), client_nbr);
                }
                file->close();
                delete file;
                return 1;
            } else {
                qDebug("File unreadable");
                return 0;
            }
        } else {
            qDebug("File not opened");
            return 0;
        }
    } else {
        qDebug("File does not exist.");
        return 0;
    }
}
