/***************************************************************************
 *   Copyright (C) 2007-2009 by Thomas Thelliez <admin.kontrol@gmail.com>  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as               *
 *   published by the Free Software Foundation; either version 2.0 of      *
 *   the License, or (at your option) any later version.                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public             *
 *   License along with this program; if not, write to                     *
 *   the Free Software Foundation, Inc.,                                   *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
 ***************************************************************************/

#include "NetworkMapDialog.h"

NetworkMapDialog::NetworkMapDialog(QGroupBox *mainBox, QList<Workstation*> *workstationList)
        :serverBox(mainBox), workstationsList(workstationList)
{
    QLabel *label = new QLabel(tr("<strong>Connect more remote workstations with KontrolPack started in client mode<br/> to get an overview of your workstations.</strong>"), this);
    QPushButton *button = new QPushButton(tr("Close"));
	setWindowTitle(tr("Network overview"));
    QGridLayout *gridBox = new QGridLayout;
    gridBox->addWidget(label, 0, 0, 1, 20);
    gridBox->addWidget(serverBox, 1, 10, 1, 1);
    for (int i = 0; i < workstationsList->size(); i++) {
        Workstation *workstation = workstationsList->at(i);
        QGroupBox *groupBox = new QGroupBox(workstation->list.at(0), this);
        QGridLayout *workstationGridBox = new QGridLayout;

        workstationGridBox->addWidget(workstation->image, 0, 0);
        for (int j = 0; j < workstation->list.size(); j++) {
            workstationGridBox->addWidget(new QLabel(QString(workstation->list.at(j))), j+1, 0);
        }
        groupBox->setLayout(workstationGridBox);
        gridBox->addWidget(groupBox, 2, 10 + i, 1, 1);
    }

    gridBox->addWidget(button, 3, 0, 1, 20);
    setLayout(gridBox);
    connect(button, SIGNAL(clicked()), this, SLOT(close()));
}

