/***************************************************************************
 *   Copyright (C) 2007-2009 by Thomas Thelliez <admin.kontrol@gmail.com>  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as               *
 *   published by the Free Software Foundation; either version 2.0 of      *
 *   the License, or (at your option) any later version.                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public             *
 *   License along with this program; if not, write to                     *
 *   the Free Software Foundation, Inc.,                                   *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
 ***************************************************************************/

#include <QString>
#include <QHostAddress>
#include <QTextBrowser>
#include <QTcpServer>
#include <QMessageBox>
#include <dirent.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include "Client.h"
#include "communication/XmlCreator.h"
#include <QMap>
#include "datastore/XmlDataStore.h"
#include <QStringList>

#define MAX_CLIENTS 	100

class Server : public QTcpServer
 {
     Q_OBJECT

    public:
	int portServer;
	bool serverStatus;
	const char* ipServer;
	Server(QObject *parent = 0);
        XmlCreator *xmlCreator;
	QMap<int, Client*> *clientList;
        QMap<int, QString>  *clientNameList;
        QMap<int, QString>  *blackList;
        QStringList filteredIpList;
	int nbrClient;
	QMap<int,Client*>* get_clientList();
	int get_client_number();
	void connect_to_client(int portnbr, const char* ip);
        int send_to_client(QString buffer, int nbr);
        void sendFile(const QString&fn, int nbr);
        void send_file_to_client(QString filePath, int fileSize, int nbr);
        void ask_file_from_client(QString fileName, int nbr);
        int send_to_all_client(QString buffer);
	int remove_client(int nbr);
	int stop_server();
	bool getServerStatus();
        bool alreadyWarm;
        bool filteredBool;

public slots:
        void getResults(QString *results, int clientNbr);
        void addNewClient();
        void getClientParameters(QStringList params, int nbr);
	void removeClientTab(QString title, int clientNbr);
	void error(QString error);
        void sendMessage(QString msg);
        void getClientContext(QStringList context, int clientNbr);
        void clientBytesSent(int bytesNbr, int fileSize);
        void endDownload(int clientNbr);

signals:
        void sendClientParameters(QStringList params, int clientNbr);
        void sendClientContextToGui(QStringList context, int clientNbr);
        void sendResults(QString *results, int clientNbr);
	void errorOccuredWhileStartingServer(QString msg);
	void removeTab(QString title, int clientNbr);
	void stopClient(int nbr);
        void warning(QString msg);
        void displayFileTransfered(QString msg);
        void bytesSent(int sizeSent);
        void fileSent(int clientNbr);
        void clientBytesSentSignal(int bytesNbr, int fileSize);
        void endDownloadSignal(int clientNbr);

 private:
	
 };




