/***************************************************************************
 *   Copyright (C) 2007-2009 by Thomas Thelliez <admin.kontrol@gmail.com>  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as               *
 *   published by the Free Software Foundation; either version 2.0 of      *
 *   the License, or (at your option) any later version.                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public             *
 *   License along with this program; if not, write to                     *
 *   the Free Software Foundation, Inc.,                                   *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
 ***************************************************************************/

#ifndef CLIENTSHELL_H
#define CLIENTSHELL_H

#include <QDialog>
#include <QTcpSocket>
#include <QFile>
#include <QByteArray>
#include <QHostInfo>
#include <QList>
#include <QMessageBox>
#include <QStringList>
#include <QHostAddress>
#include <QPushButton>
#include <QGroupBox>
#include <QTimer>
#include "ExecThread.h"
#include "main/common/xml_constants.h"
#include "communication/XmlResultsParserClient.h"
#include "communication/XmlCreatorClient.h"
#include "datastore/XmlDataStore.h"

QT_BEGIN_NAMESPACE
class QDialogButtonBox;
class QLabel;
class QFile;
class QLineEdit;
class QPushButton;
class QTcpSocket;
QT_END_NAMESPACE

class ClientShell : public QWidget
{
    Q_OBJECT

public:

    ClientShell();
    QCheckBox *checkbox;
    int ret;
    char contextKontrol[2000];
    QTimer *timer;
    QList<QHostAddress> addresses;
    QLabel *image;
    QGroupBox *groupBox;
    QLabel *path;
    QPushButton *startButton;
    QPushButton *stopButton;
    QLineEdit *portLine;
    QLineEdit *ipLine;
    QLabel *statusLabel;
    QString readMode;
    QFile file;
    QString filePath;
    QString fileAsked;
    ExecThread *thread;
    int fileSize;
    int bytesCount;
    void autoConnect();
public slots:
    void connectToServer();
    void stopFileTransfer();
    void stopClient();
    void sendEndCommandToSocket();
    void checked(int check);

private slots:
    void readFromServer();
    void displayError(QAbstractSocket::SocketError socketError);
    void onConnect();
    void sendClientInformation();
    void onDisconnect();
    void tryConnecting();
    void sendToSocket(QByteArray data);
signals:
    void hideUi();
private:
    void tellServerFileTransfertSucceeded();
	void tellServerFileTransfertFailed();
    void sendAskedFileToserver();
    XmlResultsParserClient *xmlParser;
    QStringList fileList;
    QLabel *hostLabel;
    QLabel *portLabel;
    QLineEdit *hostLineEdit;
    XmlCreatorClient *xmlCreator;
    QLineEdit *portLineEdit;
    bool isClientConnected;
    bool disconnectedByServer;
    int i;
    QTcpSocket *tcpSocket;
    QString currentFortune;
    quint16 blockSize;

};

#endif
