/***************************************************************************
 *   Copyright (C) 2005 by Tommaso Frazzetto   *
 *   tommaso.frazzetto@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef _KOMPILE_H_
#define _KOMPILE_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <ksystemtray.h>

#include <kmainwindow.h>
#include <qstring.h>

#include "kompilewidget.h"

class KompileWidget;

/**
 * @short Application Main Window
 * @author Tommaso Frazzetto <tommaso.frazzetto@gmail.com>
 * @version 0.1
 */
class Kompile : public KMainWindow
{
    Q_OBJECT
    QString tarball;
    KompileWidget * widget;
    KSystemTray * trayicon;

public:
    static const int OPERATION_INSTALL = 1;
    static const int OPERATION_UNINSTALL = 0;

    /**
     * Default Constructor
     */
    Kompile(QString &filename, const int operation = OPERATION_INSTALL, bool default_installation = false);

    /**
     * Default Destructor
     */
    virtual ~Kompile();

    bool setSourcesTarball(QString &filename);
    QString sourcesTarball();
    void startInstallation();
    void setTrayiconTooltip(QString message);

protected:
    virtual bool event(QEvent* e);
};

#endif // _KOMPILE_H_
