<?php
/*  
 *  COPYRIGHT
 *  ---------
 *
 *  See docs/AUTHORS file
 *
 *
 *  LICENSE
 *  -------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  $Revision: 1.8 $
 *
 *  ABOUT
 *  -----
 *
 *  This script generates partial free/busy information based on a
 *  single calendar folder on the Kolab groupware server. The partial
 *  information is cached an later assembled for display by the
 *  freebusy.php script.
 *
 */

/* Load the required free/busy libraries - this also loads Horde:: and
 Util:: as well as the PEAR constants*/ 
require_once 'Kolab/Freebusy/Page.php';

/* Load the configuration */ 
require_once 'config.php';

/* Profiling */
$timer = &new Timer();

/* Get the folder name */
$req_folder = Util::getFormData('folder', '');

Horde::logMessage(sprintf(_("Starting generation of partial free/busy data for folder %s"), 
                          $req_folder), __FILE__, __LINE__, PEAR_LOG_DEBUG);

/* Validate folder access */
$access = &new FolderAccess();
$result = $access->parseFolder($req_folder);
if (is_a($result, 'PEAR_Error')) {
    Kolab_Freebusy_Error::notFound($result);
}

Horde::logMessage(sprintf(_("Partial free/busy data of owner %s on server %s requested by user %s."),
                          $access->owner, $access->homeserver, $access->user), 
                  __FILE__, __LINE__, PEAR_LOG_DEBUG);

/* Try to fetch the data if it is stored on a remote server */
$result = $access->fetchRemote();
if (is_a($result, 'PEAR_Error')) {
    Kolab_Freebusy_Error::unauthorized($result);
}

/* Load the cache class now */
require_once('Kolab/Freebusy/Cache.php');

/* Where is the cache data stored? */
if (!empty($conf['fb']['cache_dir'])) {
    $cache_dir = $conf['fb']['cache_dir'];
} else {
    /* This default is not recommended so make sure you set a 
     * cache dir outside of the apache document root.
     */
    $cache_dir = dirname(__FILE__) . '/cache';
}

/* Get the cache request variables */
$req_cache    = Util::getFormData('cache', false);
$req_extended = Util::getFormData('extended', false);

$cache = &new FreeBusyCache($cache_dir);

if (!$req_cache) {
    /* User wants to regenerate the cache */

    /* Here we really need an authenticated IMAP user */
    $result = $access->authenticate();
    if (is_a($result, 'PEAR_Error')) {
        Kolab_Freebusy_Error::unauthorized($result);
    }

    if (empty($access->owner)) {
        $message = sprintf(_("No such account %s!"), 
                           htmlentities($access->req_owner));
        Kolab_Freebusy_Error::notFound(PEAR::raiseError($message));
    }

    /* Update the cache */
    $result = $cache->store($access);
    if (is_a($result, 'PEAR_Error')) {
        Kolab_Freebusy_Error::notFound($result);
    }
}

/* Load the cache data */
$vfb = $cache->loadPartial($access, $req_extended);
if (is_a($vfb, 'PEAR_Error')) {
    Kolab_Freebusy_Error::notFound($vfb);
}

Horde::logMessage(sprintf(_("Delivering partial free/busy data (extended=%s)."),
                          $req_extended), 
                  __FILE__, __LINE__, PEAR_LOG_DEBUG);

/* And finally send it out */
$view = &new FreeBusyView($vfb);
$view->render($access->owner . '.ifb');

/* Finish up */
Horde::logMessage(sprintf(_("Partial free/busy generation complete, execution time was %s seconds."), 
                          $timer->stop()), __FILE__, __LINE__, PEAR_LOG_DEBUG);
?>
