<?php

/*  
 *  COPYRIGHT
 *  ---------
 *
 *  See docs/AUTHORS file
 *
 *
 *  LICENSE
 *  -------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  $Revision: 1.7 $
 *
 *  ABOUT
 *  -----
 *
 *  This file provides configuration settings for both the
 *  freebusy.php and the pfb.php scripts.
 *
 */

$conf = array();

/* Horde::Log configuration */
$conf['log']['enabled']          = true;
$conf['log']['priority']         = PEAR_LOG_DEBUG; // Leave this on DEBUG for now. We just restructured the package...
$conf['log']['type']             = 'file';
$conf['log']['name']             = '/kolab/var/kolab-freebusy/log/freebusy.log';
$conf['log']['ident']            = 'Kolab Free/Busy';
$conf['log']['params']['append'] = true;

/* PHP error logging */
ini_set('error_log', '/kolab/var/kolab-freebusy/log/php-error.log');

/* Horde::Kolab::LDAP configuration */
$conf['kolab']['ldap']['server'] = 'example.com';
$conf['kolab']['ldap']['basedn'] = 'dc=example,dc=com';
$conf['kolab']['ldap']['phpdn']  = 'cn=nobody,cn=internal,dc=example,dc=com';
$conf['kolab']['ldap']['phppw']  = 'xyz';

/* Horde::Kolab::IMAP configuration */
$conf['kolab']['imap']['server']   = 'example.com';
$conf['kolab']['imap']['port']     = 143;
$conf['kolab']['imap']['protocol'] = 'notls/readonly';

/* Horde::Auth configuration */
$conf['auth']['params']['login_block'] = 0;
$conf['auth']['checkbrowser']          = false;
$conf['auth']['checkip']               = false;

/* Kolab::Freebusy configuration */

/* Should we redirect using a Location header, if the user is not local? If this
 * is false we silently download the file ourselves and output it so that it
 * looks as though the free/busy information is coming from us.
 */
$conf['fb']['redirect']     = false;

/* What is the address of the current server where the calendar data is stored?
 * This is also used as the LDAP server address where user objects reside.
 */
$conf['fb']['server']       = 'example.com';

/* What is our default mail domain? This is used if any users do not have
 * '@domain' specified after their username as part of their email address.
 */
$conf['fb']['email_domain'] = 'example.com';

/* Location of the cache files */
$conf['fb']['cache_dir']    = '/kolab/var/kolab-freebusy/cache';

/* What db type to use for the freebusy caches */
$conf['fb']['dbformat']     = 'db4';

/* Should we send a Content-Type header, indicating what the mime type of the
 * resulting VFB file is?
 */
$conf['fb']['send_content_type'] = false;

/* Should we send a Content-Length header, indicating how large the resulting
 * VFB file is?
 */
$conf['fb']['send_content_length'] = false;

/* Should we send a Content-Disposition header, indicating what the name of the
 * resulting VFB file should be?
 */
$conf['fb']['send_content_disposition'] = false;

/* Are there remote servers on which users have additional (shared)
 * folders? In that case free/busy information should also be fetched
 * from these servers.
 *
 * Add them like this:
 *
 * array('remote1.example.com', 'remote2.example.com')
 */
$conf['fb']['remote_servers'] = array();

//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//
// If you modify this file, please do not forget to modify both the
// template in kolabd and the source file in kolab-freebusy
//
// In order to check if both are in sync:
//
// cd server
// diff -Nau kolab-freebusy/freebusy/config.php kolabd/kolabd/templates/freebusy.conf.template.in
//
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

// DEBUGGING
// =========
//
// Activate this to see the log messages on the screen
// $conf['log']['type'] = 'display';
//
// Activate this to see the php messages on the screen
// ini_set('display_errors', 1);
//
// Both setting will disrupt header delivery (which should not cause a
// problem).
