
/***************************************************************************
 *                                                                         *
 *   KCPULoad and KNetLoad are copyright (c) 1999-2000, Markus Gustavsson  *
 *                                       (c) 2002, Ben Burton              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ICONTOGGLEACTION_H
#define __ICONTOGGLEACTION_H

#include <kaction.h>

/**
 * A toggle action that uses different labels and pixmaps in its
 * different states.
 */
class IconToggleAction : public KToggleAction {
    Q_OBJECT

    public:
        /**
         * Constructors.
         */
        IconToggleAction(
            const QString& useTextUnchecked, const QString& useIconUnchecked,
            const QString& useTextChecked, const QString& useIconChecked,
            const KShortcut& cut, const QObject* receiver, const char* slot,
            QObject* parent, const char* name = 0);
        IconToggleAction(const QString& useText,
            const QString& useIconUnchecked, const QString& useIconChecked,
            const KShortcut& cut, const QObject* receiver, const char* slot,
            QObject* parent, const char* name = 0);
        IconToggleAction(
            const QString& useTextUnchecked, const QString& useIconUnchecked,
            const QString& useTextChecked, const QString& useIconChecked,
            const KShortcut& cut = KShortcut(), QObject* parent = 0,
            const char* name = 0);
        IconToggleAction(const QString& useText,
            const QString& useIconUnchecked, const QString& useIconChecked,
            const KShortcut& cut = KShortcut(), QObject* parent = 0,
            const char* name = 0);

        /**
         * Overridden to include icon adjustment.
         */
        virtual void setChecked(bool);

    private:
        QString textChecked, textUnchecked;
            /**< The labels to use in the checked and unchecked states. */
        QString iconChecked, iconUnchecked;
            /**< The icons to use in the checked and unchecked states. */
};

#endif
