/***************************************************************************
 *   Copyright (C) 2005 by yodor   *
 *   yodor@developer.bg   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef MYDOCK_H
#define MYDOCK_H

#include <ksystemtray.h>
#include <qtimer.h>
#include <qstring.h>

#include "netsettingsdialog.h"


#include "global.h"

#define NL_BUFSIZE 8192

#include "TTip.h"


/**
@author yodor
*/


class mydock : public KSystemTray
{
Q_OBJECT

public:

    mydock();
   ~mydock();


public slots:
   
    void showSettings();
    bool queryDevices();
	void update();
	void start();
	void saveState();
	void setIface(const QString&);
        void hideInstance();
	void disableTip();

int getBack();
int getAhead();

private slots:
    void mousePressEvent(QMouseEvent * e);
    void mouseReleaseEvent(QMouseEvent * e);

protected:
    virtual void paintEvent (QPaintEvent *);
	virtual void enterEvent(QEvent *);
	virtual void leaveEvent(QEvent *);
	virtual void mouseEnterEvent(QMouseEvent *e);
	KNetDockIf *allifs;
	int readSock(int sockFd, char *bufPtr, int seqNum, int pId);
	void updateTip(const QString& tip,double speed=0, const QString& lbl = "");
	void updateDockIcon(int mode);

signals:
	void ifacechange();
	void updateStats(const net_device_stats*, const IfStat *);
	void updateWiFi(const WiFiStat*);
	void updateInfo(const AddrStat*);
	

private:
	int tipMenuID;
	bool tipEnabled;

	QString if_name;
	NetSettingsDialog *netset;
	QTimer *ifupdater;
	
	

	int c_icon;
	int msgSeq;
	int nlsock;
	int fdsock;

	
	void disableDevice();
		

	iw_statistics *stats;
	char msgBuf[NL_BUFSIZE];
	//InfoPopup *ttip;
	TTip *popup;
	char	rngbuf[sizeof(struct iw_range) * 2];
	int r_index;
	
};

#endif
