
#include "TTip.h"
#include <qlabel.h>
#include <qpainter.h>
#include <qhbox.h>
#include <qvbox.h>
#include <qlayout.h>
#include <qcolor.h>


TTip::TTip(QWidget* parent, const char* name) : QWidget (0,"TTIP",WX11BypassWM)
{
	
	setBackgroundMode(NoBackground);
	
	QHBoxLayout *h = new QHBoxLayout(this,10,5);
	h->setAutoAdd(true);

	m_view = new InfoPopup(this);
	
	
	m_view->adjustSize();
	adjustSize();
	clearWState( WState_Polished );
}
TTip::~TTip()
{
	delete m_view;
}
void TTip::updateTip( const QString & e, double speed, const QString& lbl)
{
    m_view->updateTip(e,speed,lbl);
}
void TTip::drawIt(QPainter *p)
{

	p->fillRect(0,0,width(),height(),backgroundBrush ());

    QBrush b2( m_view->paletteBackgroundColor() );//, Qt::Dense6Pattern );          // green 12% fill
//     QBrush b3( Qt::NoBrush );                           // void brush
// 	p->setBrush(b3);
// 	p->clearRect(0,0,width(),height());

    //QBrush b4( Qt::CrossPattern );                      // black cross pattern
   
    p->setBrush( b2 );
    p->drawRoundRect( 0, 0, width(), height(), 1600/width(), 1600/height() );
   
}
void TTip::paintEvent(QPaintEvent *e)
{
	QPainter p(this);
	drawIt(&p);
}

void TTip::fontChange(const QFont & f)
{
	m_view->adjustSize();
	adjustSize();
}
void TTip::paletteChange( const QPalette & oldPalette )
{
	m_view->adjustSize();
	adjustSize();
	
	setPalette(m_view->palette());
	repaint();
}
void TTip::styleChange( const QStyle & oldStyle )
{
	m_view->adjustSize();
	adjustSize();
	setStyle(&m_view->style());
	repaint();
}