/***************************************************************************
 *   Copyright (C) 2005 by yodor   *
 *   yodor@developer.bg   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "chartframe.h"
#define STEP 5

ChartFrame::ChartFrame(QWidget *parent, const char *name) : QWidget(parent,name)
{
	//setPaletteBackgroundColor(Qt::black);
	setWFlags(Qt::WNoAutoErase);
}

ChartFrame::~ChartFrame()
{
	delete values;
}

void ChartFrame::init()
{
	w = (width())/STEP;
	values = new float[w];
}
void ChartFrame::clearChart()
{
	offset_w=-1;

	for (int i=0; i<w;i++)
	{
		values[i]=0.0f;
	}
	repaint();
}

void ChartFrame::setValue(int index, float val)
{
	values[index]=val;
	float scale = (float)height()/maxRate;
	
	if (val==0)
	{
		maxRate=height();
	}
	else if (val > maxRate)	
	{
		maxRate=val*2;
	}
	//else if (val < maxRate/scale)
	else if (val < maxRate/height())
	{
		maxRate=val*2;
	}
	
	
}
float ChartFrame::getValue(int index)
{
	return values[index];
}

void ChartFrame::paintEvent(QPaintEvent *e)
{
	QPainter paint(this);

	QPen pen = paint.pen();

	
	int hh = height();
	int ww = width();
/*
	for (int a=0;a<=offset_w;a++)
	{
			float val = ((float)h/(float)maxRate) * values[a];	
			if (val>h)val=h;

			pen.setColor(Qt::red);
			paint.setPen(pen);
			paint.drawLine(a*3,(int)(h-val),a*3,h);
			pen.setColor(Qt::green);
			paint.setPen(pen);
			paint.drawLine((a*3)+2,h,(a*3)+2,h-1);	
	}*/
	pen.setColor(QColor(100,0,0));
	pen.setWidth(1);	
	paint.setPen(pen);
	
	for (int a=STEP-1;a<ww;a+=STEP)
	{
		paint.drawLine(a,0,a,hh);	
	}
	for (int a=STEP-1;a<hh;a+=STEP)
	{
		paint.drawLine(0,a,ww,a);	
	}
	pen.setColor(Qt::red);
	pen.setWidth( 1 );
	paint.setPen(pen);
	int x= 0;
	int y= ((float)hh/(float)maxRate) * values[0];	

	for (int a=0;a<=offset_w;a++)
	{
			float val = ((float)hh/(float)maxRate) * values[a];	
			if (val>hh)val=hh;

			
			paint.drawLine(x,y,a*STEP,(int)(hh-val));
			//paint.drawLine(a*3,(int)(h-val),a*3,h);
			x=a*STEP;
			y=hh-val;
	}
	if(offset_w==(w-1))
		paint.drawLine(x,y,ww,y);
}
float ChartFrame::getMaxRate()
{
	return maxRate;
}
void ChartFrame::setMaxRate(float mrate)
{
	maxRate=mrate;
	if (maxRate<1)
		maxRate=1;
}
int ChartFrame::nextValue()
{
	if (offset_w==(w-1))
	{
		for (int a=0;a<(w-1);a++)
		{
				values[a]=values[a+1];
		}
	}
	else
	{
		offset_w++;
	}
// 	if (offset_w==w)
// 		offset_w=0;
	return offset_w;
}

