/***************************************************************************
 *   Copyright (C) 2005 by Judd Baileys                                    *
 *   jbaileys@bigpond.net.au                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef OSD_H
#define OSD_H

#include <qwidget.h>
#include <qimage.h>
#include <kpixmap.h>

class DockWidget;

class OSDWidget : public QWidget
{
    Q_OBJECT

    public:
        enum Alignment { Left, Middle, Center, Right };

        OSDWidget( QWidget *parent, const char *name = "osd" );

        /** resets the colours to defaults */
        void unsetColors();
	void setAnchor(const QPoint &anchor);

      public slots:
        /** calls setText() then show(), after setting image if needed */
        void show( const QString &text, QImage newImage = QImage::QImage() );

        /** reimplemented, shows the OSD */
        virtual void show();

        /**
         * For the sake of somplicity, when these settings are
         * changed they do not take effect until the next time
         * the OSD is shown!
         *
         * To force an update call show();
         */
        void setDuration( int ms ) { m_duration = ms; }
        void setTextColor( const QColor &color ) { setPaletteForegroundColor( color ); }
        void setBackgroundColor(const QColor &color ) { setPaletteBackgroundColor( color ); }
        void setOffset( int y ) { m_y = y; }
        void setAlignment( Alignment alignment ) { m_alignment = alignment; }
        void setImage( const QImage &image ) { m_cover = image; }
        void setScreen( int screen );
        void setText( const QString &text ) { m_text = text; }
        void setDrawShadow( bool b ) { m_drawShadow = b; }
        void setTranslucency( bool b ) { m_translucency = b; }

    protected:
        /** determine new size and position */
        QRect determineMetrics( const uint marginMetric );

        /** render OSD */
        void render( const uint marginMetric, const QSize &size );

        /** reimplemented */
        virtual void mousePressEvent( QMouseEvent* );
        virtual bool event( QEvent* );

        /** distance from screen edge */
        static const int MARGIN = 15;

        int         m_duration;
        QTimer     *m_timer;
        Alignment   m_alignment;
        int         m_screen;
        uint        m_y;
        bool        m_drawShadow;
        bool        m_translucency;
        QString     m_text;
        QImage      m_cover;
        QPixmap     m_scaledCover;
        KPixmap     m_screenshot;
        QPixmap     m_buffer;
	int 	    xx;
	int	    yy;

signals:
	void hideWin();

private:
	QPoint mAnchor;
	QPoint mAnchor2;
	DockWidget *dock_widget;

};

#endif
