/***************************************************************************
 *   Copyright (C) 2005 by Judd Baileys                                    *
 *   jbaileys@bigpond.net.au                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef NETWORKDEV_H
#define NETWORKDEV_H

#include <networkConfig.h>
#include <klistview.h>
#include <kpopupmenu.h>
#include <qcolor.h>
#include <qwidget.h>
#include <qcursor.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qmovie.h>
#include <qtimer.h>

#include "internetsetup.h"

class knet;
class QStringList;
class KListView;
class QListViewItem;
class EthernetScan;
class openingDialog;
class modemScan;
class QMovie;
class QLabel;
class internetSetup;
class accountSetup;
class SettingsDialog;
class Settings;
class internetWidget;

const int NUM_OF_ATI = 8;

class NetworkDev : public networkWidget
{
Q_OBJECT
public:
    NetworkDev(QWidget *parent=0, const char *name = 0, const QStringList &list = QStringList( )); // WFlags f = 0);

    ~NetworkDev();
    QListViewItem* item;

    QListViewItem* ethcards;
    QListViewItem* modems;   
    modemScan* modemscan;   
    QMovie      movie;
    EthernetScan* ethernetscan;  
    openingDialog* openingdialog;
    internetSetup* internetsetup;
    internetWidget* scriptsetup;
    accountSetup* accountsetup;    
    SettingsDialog* settingsdialog;
    QString page;
    KPopupMenu* settingsMenu;    
 //   QPixmap* mypixmap;
// signals:
public slots:
//   void popupMenu(QListBoxItem* item);
   void popupMenu(QListViewItem* );
   void itemSelected(QListViewItem* );
   void iterateList();
   void slotModemSetup();
   void slotInternetSetup();
   void slotEnableDevice();
   void slotDisableDevice();
   void slotDocking();
   void dslConnection();
   void newDialupConnection();
   void dialupConnection();
   void cableConnection();
   void isdnConnection();
   void setIcon(const QString &b);   
   void editAccount();
   void newAccount();
   void newScriptAccount();
   void scriptConnection();
   void deleteAccount();
   void settings();
   void init();
   void readtty();
   void do_script();
   void readChar(unsigned char);    
   void slotSettingsSetup();
   void setBackground(const QString & url);
   void testOSD();
   QColor bgcolor;
   QColor fgcolor;
   void deleteModem();
   void modemSettings();
   void preModemSettings();
   void modeminsert();
   void applyModem();

signals:
  void OSDTest(); 

 private:
  void ati_done();  
     
private slots:
   void slotConfigure();

   
protected:
//virtual void mousePressEvent( QMouseEvent* );

private:
    int step;
    QString readbuffer;    
    QGridLayout* ethernetLayout;   
    QTimer *scripttimer;
    knet *m_knet;
//    QTimer *timeout_timer;   
    QString ati_query_strings[NUM_OF_ATI];
}; 

#endif
