#include <klocale.h>
#include "knap_napigatordlg.h"
#include "support_funcs.h"
#include "../config.h"

#include <qframe.h>
#include <qheader.h>
#include <qlabel.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

#include <ksock.h>
#include <qfile.h>
#include <qtimer.h>
#include <qtextstream.h> 

//#include <sys/socket.h>
#include <sys/types.h>
#include <sys/time.h>
#include <unistd.h>
#include <stdlib.h>
#include <iostream>

class NapigatorItem 
 : public QListViewItem 
{
public:
  NapigatorItem(QListView *parent,const char *s1,const char *s2,const char *s3,
      const char *s4,const char *s5,const char *s6)
    : QListViewItem(parent,s1,s2,s3,s4,s5,s6)
  {

  }
  virtual QString key(int col,bool asc) const
  {
    static QString ret;
    if(col>=3) { // sort the size on users, files or gigabytes
        ret.sprintf( "%012ld", QString((QListViewItem::text(col))).toLong() );
        return ret;
    }
    else if(col==0) { // server - convert to a fixed length
        int p0,p1,p2,p3;
        sscanf(text(col),"%d.%d.%d.%d",&p0,&p1,&p2,&p3);
        ret.sprintf( "%03d%03d%03d%03d",p0,p1,p2,p3 );
        return ret;
    }
    return QListViewItem::text(col);
  }
};


/* 
 *  Constructs a KNAP_NapigatorDlg which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
KNAP_NapigatorDlg::KNAP_NapigatorDlg( QWidget* parent,  const char* name, bool modal, WFlags fl )
: QDialog( parent, name, modal, fl ), EZThread()
{

    status = STAT_CONNECT;
   
    if ( !name )
	setName( "napigator" );
    resize( 485, 485 ); 
    setCaption( i18n( "Connect via Napigator"  ) );
    setSizeGripEnabled( TRUE );
    setBackgroundOrigin( QDialog::ParentOrigin );
    napigatorLayout = new QVBoxLayout( this ); 
    napigatorLayout->setSpacing( 6 );
    napigatorLayout->setMargin( 11 );

    statustext = new QLabel( this, "statustext" );
    statustext->setText( i18n( "Connecting..."  ) );
    statustext->setFrameShape( QLabel::Panel );
    statustext->setFrameShadow( QLabel::Sunken );
    napigatorLayout->addWidget( statustext );

    serverlist = new QListView( this, "serverlist" );
    serverlist->addColumn( i18n( "Server" ) );
    serverlist->addColumn( i18n( "Port" ) );
    serverlist->addColumn( i18n( "Name" ) );
    serverlist->addColumn( i18n( "Users" ) );
    serverlist->addColumn( i18n( "Songs" ) );
    serverlist->addColumn( i18n( "Gigabytes" ) );
    serverlist->setAllColumnsShowFocus(true);
    //serverlist->loadWidths();
    napigatorLayout->addWidget( serverlist );

    unnamed = new QFrame( this, "unnamed" );
    unnamed->setFrameStyle( QFrame::HLine | QFrame::Sunken );
    napigatorLayout->addWidget( unnamed );

    Layout2 = new QGridLayout; 
    Layout2->setSpacing( 6 );
    Layout2->setMargin( 0 );

    cancelbtn = new QPushButton( this, "cancelbtn" );
    cancelbtn->setText( i18n( "&Cancel"  ) );
    cancelbtn->setAutoDefault( TRUE );

    Layout2->addWidget( cancelbtn, 0, 3 );

    helpbtn = new QPushButton( this, "helpbtn" );
    helpbtn->setText( i18n( "&Help"  ) );
    helpbtn->setAutoDefault( TRUE );

    Layout2->addWidget( helpbtn, 0, 0 );

    connectbtn = new QPushButton( this, "connectbtn" );
    connectbtn->setText( i18n( "&Connect"  ) );
    connectbtn->setAutoDefault( TRUE );
    connectbtn->setDefault( TRUE );
    connectbtn->setEnabled( FALSE );

    Layout2->addWidget( connectbtn, 0, 2 );
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout2->addItem( spacer, 0, 1 );
    napigatorLayout->addLayout( Layout2 );

    // signals and slots connections
    connect( connectbtn, SIGNAL( clicked() ), this, SLOT( connectPressed() ) );
    connect( cancelbtn, SIGNAL( clicked() ), this, SLOT( reject() ) );
    connect( serverlist,SIGNAL( selectionChanged() ), this, SLOT( serverSelected() ) );

    // set up timer for checking status
  QTimer *timer=new QTimer(this);
  if(timer) {
     connect(timer,SIGNAL(timeout()),this,SLOT(timeout()));

     timer->start(500); // update every 1/2 second
  }

  run();
    
}

/*  
 *  Destroys the object and frees any allocated resources
 */
KNAP_NapigatorDlg::~KNAP_NapigatorDlg()
{
    // no need to delete child widgets, Qt does it all for us

   kill();

  // delete tmp file if there is one
  down();
    if(tmp_name.isNull()==false) QFile::remove(tmp_name);
  up();

}
bool KNAP_NapigatorDlg::parseLine(QString str)
{
  if(!str) return false;

  // first line should be HTTP/1.1 200 OK or similar
  QString ip,port,name,users,songs,gig;

  ip = extractString(str);
  port = extractString(str);
  name = extractString(str);
  users=extractString(str);
  songs = extractString(str);
  gig   = extractString(str);
  // setrver_address_string

  if(users.toInt() == -1) users = i18n("Unknown");
  if(songs.toInt() == -1) songs = i18n("Unknown");
  if(gig.toInt() == -1) gig = i18n("Unknown");

  QListViewItem *i;

  // put the item in the listview
  if(!gig.isNull())
     i=new NapigatorItem(serverlist,ip,port,name,users,songs,gig);

  return false;
}

void KNAP_NapigatorDlg::run_method()
{
  fd_set fdsr;
  struct timeval tm;
  KSocket *sock;
  int len;
  char buff[1024];
  bool err=true;
down();
  status = STAT_CONNECT;
up();

//  if((sock = new KSocket("lost.bard",80))!=NULL && sock->socket()!=-1)
  if((sock = new KSocket("www.napigator.com",80))!=NULL && sock->socket()!=-1)
  {
#ifdef DEBUG_1
     cerr<<"opened connection to napigator\n"<<flush;
#endif
     // get the napigator file
//     QString sdata = "GET /servers.php?version=" VERSION "&client=knapster HTTP/1.0\n\n";
     QString sdata = "GET http://www.napigator.com/servers.php?version=" VERSION "&client=knapster HTTP/1.0\n\n";

     send(sock->socket(),sdata,sdata.length(),0);
#ifdef DEBUG_1
     cerr<<"sent request of " << sdata <<endl<<flush;
#endif
     down();
       tmp_name = getTempFileName();
     up();

     QFile file(tmp_name);
     if(file.open(IO_ReadWrite))
     {
#ifdef DEBUG_1
       cerr<<"got opened tmp file " << tmp_name<<endl;
#endif

       down();
         status = STAT_READING;
       up();
       
       // process incoming data until close of pipe
       FD_ZERO(&fdsr);
       FD_SET(sock->socket(),&fdsr);

       tm.tv_sec=60;
       tm.tv_usec=0;

       while(select(sock->socket()+1,&fdsr,NULL,NULL,&tm)>0)
       {
         len = recv(sock->socket(),buff,1024,0);
#ifdef DEBUG_1
         cerr<<"read napigator data of size "<< len<<endl<<flush;
#endif
         if(len<=0) break;
         if(len>0) file.writeBlock(buff,len);

         FD_ZERO(&fdsr);
         FD_SET(sock->socket(),&fdsr);
         tm.tv_sec=60;
         tm.tv_usec=0;
       }

       err = false;
     }
     else {
#ifdef DEBUG_1
       cerr<<"Couldnt open file " << tmp_name<<endl<<flush;
#endif
     }

     down();
      if(err==true) status = STAT_ERROR;
      status = STAT_DONE;
     up();

     delete sock; // remove the socket
  }
  else {
#ifdef DEBUG_1
    cerr<<"could not get napigator socket\n"<<flush;
#endif
    down();
     status = STAT_NOCONNECT;
    up();
  }
#ifdef DEBUG_1
  cerr<<"end of napigator stuff\n"<<flush;
#endif
  return;
}

void KNAP_NapigatorDlg::timeout()
{
  if(status == STAT_END) return;

down();

  switch(status)
  {
    case STAT_CONNECT:
       statustext->setText(i18n("connecting to napigator..."));
       break;
    case STAT_PARSING:
       statustext->setText(i18n("parsing napigator data..."));
       break;
    case STAT_READING:
       statustext->setText(i18n("reading server list..."));
       break;
    case STAT_DONE:
       // do the population here
       parseFile();
       statustext->setText(i18n("Done"));
       status = STAT_END;
       break;

    // error cases

    case STAT_NOCONNECT:
       statustext->setText(i18n("Error: Cant connect to napigator"));
       status = STAT_END;
       break;
    case STAT_ERROR:
       statustext->setText(i18n("Error while getting napigator data"));
       status = STAT_END;
       break;

    case STAT_INVALIDDATA:
       statustext->setText(i18n("Error: invalid data received from napigator."));
       status = STAT_END;

       break;
    case STAT_SERVERERROR:
       statustext->setText(i18n("Error from server: ") + servertxt);
       status = STAT_END;
       break;
    default:
      status = STAT_END;
      break;
  }
up();
  return;
}

bool KNAP_NapigatorDlg::parseFile()
{
  QFile file(tmp_name);
  if(!file.open(IO_ReadOnly)) return false;

  QTextStream t( &file );        // use a text stream
  QString str="";

  str = t.readLine();       // read first line

  if(strncmp("HTTP",str,4)!=0)
  {
    status = STAT_INVALIDDATA;
    // "Invalid file data received:"
    return false;
  }
  extractString(str); // skip first bit ( the HTTP/XXXX )
  QString stattext = extractString(str); // get out a number

  if(stattext.toInt()!=200)
  {
    // "Error getting napigator server list
    status = STAT_SERVERERROR;
    servertxt =  stattext + ": " + str;
    return false;
  }
  // "processing napigator list...
  status = STAT_PARSING;

  bool inheader = true;

  while ( !t.eof() )          // until end of file...
  {
    str = t.readLine();       // line of text excluding '\n'
    if(!inheader)
      parseLine(str);
    else if(str.isEmpty())
      inheader = false;       // found end of http header
  }
  return true;
}

QString KNAP_NapigatorDlg::getSelectedServer()
{
  return selectedserver;
}

void KNAP_NapigatorDlg::serverSelected()
{
     connectbtn->setEnabled(true);
} 
void KNAP_NapigatorDlg::connectPressed()
{
  QListViewItem *i = serverlist->selectedItem();
 
  if(i && i->text(0))
  {
     selectedserver = QString(i->text(0)) + ":" + i->text(1);
     accept();
  } 
}
