#include "stringhelper.h"
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <ctype.h>

#include <qstring.h>

std::string FormatSTLString(const char*Format,...)
{
    std::string msg = "";
    char*buffer;
    int chars;

    va_list ap;
    va_start(ap,Format);
    int size = 100;

    buffer = new char[size];

    while (1) {
#ifndef _WIN32
        chars = vsnprintf(buffer,size,Format,ap);
#else
        chars = _vsnprintf(buffer,size,Format,ap);
#endif
        if (chars > -1 && chars < size) {
            break;
        }
        if (chars>-1) {
            size=chars+1;
        } else {
            size*=2;
        }
        delete[]buffer;
        buffer = new char[size];
    }
    va_end(ap);

    if (buffer) {
        msg = buffer;
        delete []buffer;
    }
    return msg;
}

bool Casecmp::operator()(const std::string&x, const std::string&y)const
{
    std::string::const_iterator p=x.begin();
    std::string::const_iterator q=y.begin();

    while (p!=x.end()&&q!=y.end()&&toupper(*p)==toupper(*q)) {
        ++p;
        ++q;
    }
    if (p==x.end()) return q!=y.end();
    return toupper(*p)<toupper(*q);
}

char Bin2Hex::hexconvtab[] = "0123456789abcdef";

Bin2Hex::Bin2Hex(const std::string&x)
    :arg(x),result(arg.size()*2+1,char(0))
{
    size_t i,j;
    for (i = j = 0; i < arg.size();++i) {
        result[j++]=hexconvtab[((unsigned char)arg.at(i)) >> 4];
        result[j++]=hexconvtab[((unsigned char)arg.at(i)) & 15];
    }
    result[j]=0;
}

const std::string&Bin2Hex::operator()()const
{
    return result;
}
