/***************************************************************************
                       kmfwizard.h  -  description
                          -------------------
 begin                : Wed Mar 20 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : a9806056@unet.univie.ac.at
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMFWIZARD_H
#define KMFWIZARD_H

#include <qwidget.h>
#include <kmyfirewallwizard.h>
#include <qptrlist.h>
#include <qstring.h>

class KMFDoc;
class IPTRule;
class KMFError;
class KMFErrorHandler;
class KMFCheckInput;

/**
*@author Christian Hubinger
*/

class KMFWizard : public KMyFirewallWizard {
	Q_OBJECT
public:
	KMFWizard( QWidget *parent = 0, const char *name = 0 );
	~KMFWizard();
	KMFDoc* kmfdoc;
	QPtrList<QString> custom_out_services;
	QPtrList<QString> custom_out_services_name;
	QPtrList<QString> custom_in_services;
	QPtrList<QString> custom_in_services_name;


public slots:
	void accept();
	void reject();
	void slotFinished( bool );
	void slotInitDocument();
	void slotPreviewScript();
	void slotAddTrusted();
	void slotDelTrusted();

	void slotAddEvil();
	void slotDelEvil();

	void slotAddServer();
	void slotDelServer();

	void slotAddClient();
	void slotDelClient();

	void slotAddOutService();
	void slotDelOutService();

	void slotAddInService();
	void slotDelInService();
	void slotHelp();
protected:
	void slotEnableNewOutService();
	void slotEnableNewInService();
	void createScript();
	void intallFirewall();
	void setupRuleset();

private:
	KMFError *m_err;
	KMFErrorHandler *m_err_handler;
	KMFCheckInput *m_check_input;
};

#endif
