/***************************************************************************
                       kmfchecklistoutput.cpp  -  description
                          -------------------
 begin                : Tue Jul 30 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : a9806056@unet.univie.ac.at
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmfchecklistoutput.h"

// QT includs
#include <qlabel.h>
#include <qlistbox.h>
#include <qpushbutton.h>
#include <qlistview.h>
#include <qlayout.h>
#include <qstring.h>

// kde includes
#include <klocale.h>
#include <kdebug.h>
#include <kglobal.h>
#include <kiconloader.h>


KMFCheckListOutput::KMFCheckListOutput( QWidget *parent, const char *name , bool modal, WFlags fl ) : QDialog( parent, name, modal, fl ) {
	setCaption( "KMyFirewall" );
	QGridLayout *l_prog = new QGridLayout( this,4,2,6,11 );
  text = new QLabel( i18n("<qt><b>Trying to guess the system configuration...</b><br>"
													"If errors are occouring you'll have to setup the configuration yourself."
													"</qt>"), this);
	l_prog -> addMultiCellWidget( text, 0, 0, 0, 2 );

	mpb_ok = new QPushButton( this, "Ok" );
	mpb_ok->setText( i18n( "&Close Window" ) );
	l_prog -> addMultiCellWidget( mpb_ok, 4, 4, 0, 2 );

	mlb_outputView = new QListView( this, "msg" );
	mlb_outputView->addColumn( i18n( "Looking For" ) );
	mlb_outputView->addColumn( i18n( "Found?" ) );
	mlb_outputView->setSelectionMode( QListView::NoSelection );
	mlb_outputView->setSorting( -1 );
	l_prog -> addMultiCellWidget( mlb_outputView, 1, 3, 0, 2 );


	connect( mpb_ok, SIGNAL( clicked() ) , this, SLOT( hide() ) );
	m_currItem = new QListViewItem( mlb_outputView );
	m_currItem->setText( 0, i18n( "Starting system scan..." ) );
	loadIcons();
	this->resize( 450, 450 );
}

KMFCheckListOutput::~KMFCheckListOutput() {}

void KMFCheckListOutput::appendLine( const QString &txt ) {
	QListViewItem * item = new QListViewItem( mlb_outputView, m_currItem );
	item->setMultiLinesEnabled( true );
	item->setText( 0, txt );
	m_currItem = item;
	kdDebug() << "void KMFCheckListOutput::appendLine(QString txt)" << endl;
}

void KMFCheckListOutput::setStatus( bool ok, const QString &err_msg ) {
	kdDebug() << "void KMFCheckListOutput::setStatus(bool ok,QString &err_msg)" << endl;
	if ( ok ) {
		m_currItem->setPixmap( 1, icon_ok );
	} else {
		m_currItem->setPixmap( 1, icon_err );
		m_currItem->setOpen( true );
		if ( err_msg != "" ) {
			QListViewItem * item = new QListViewItem( m_currItem );
			item->setText( 0, err_msg );
		}
	}
}

void KMFCheckListOutput::clearList() {
	kdDebug() << "void KMFCheckListOutput::clearList()" << endl;
	mlb_outputView->clear();
}

void KMFCheckListOutput::loadIcons() {
	kdDebug() << "void KMFCheckListOutput::loadIcons()" << endl;
	KIconLoader *loader = KGlobal::iconLoader();
	QString icon_name;

	icon_name = "stop";
	icon_err = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "button_ok";
	icon_ok = loader->loadIcon( icon_name, KIcon::Small );

}
#include "kmfchecklistoutput.moc"
