/***************************************************************************
                       kmfruleedittargetlog.cpp  -  description
                          -------------------
 begin                : Wed May 22 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : a9806056@unet.univie.ac.at
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmfruleedittargetlog.h" 
// QT includes
#include <qstring.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qlineedit.h>

// kde includes
#include <kapplication.h>
#include <kdebug.h>

// MY includes
#include "../core/iptrule.h"
KMFRuleEditTargetLog::KMFRuleEditTargetLog( QWidget *parent, const char *name, WFlags fl ) : KMyFirewallRuleEditorTargetLog( parent, name, fl ) {}
KMFRuleEditTargetLog::~KMFRuleEditTargetLog() {}

void KMFRuleEditTargetLog::loadRule( IPTRule* rule ) {
	kdDebug() << "void KMFRuleEditTargetLog::loadRule( IPTRule* rule )" << endl;
	c_log_tcp_seq->setChecked( false );
	c_log_tcp_options-> setChecked( false );
	c_log_ip_options->setChecked( false );
	c_log_prefix-> setChecked( false );
	c_log_level ->setChecked( false );
	cb_log_level->setCurrentItem( 0 );
	t_log_prefix->clear();
	curr_rule = rule;
	QPtrList<QString>* curr_opt = new QPtrList<QString>;
	QPtrList<QPtrList<QString> > options = curr_rule->ruleTargetOptions();
	for ( uint i = 0;i < options.count();i++ ) {
		curr_opt = options.at( i );
		if ( *curr_opt->at( 0 ) == "log_tcp_seq" )
			c_log_tcp_seq->setChecked( true );
		if ( *curr_opt->at( 0 ) == "log_tcp_options" )
			c_log_tcp_options->setChecked( true );
		if ( *curr_opt->at( 0 ) == "log_ip_options" )
			c_log_ip_options->setChecked( true );
		if ( *curr_opt->at( 0 ) == "log_prefix" ) {
			c_log_prefix->setChecked( true );
			t_log_prefix->setText( *curr_opt->at( 1 ) );
		}
		if ( *curr_opt->at( 0 ) == "log_level" ) {
			c_log_level->setChecked( true );
			cb_log_level ->setCurrentText( *curr_opt->at( 1 ) );
		}


	}
}

void KMFRuleEditTargetLog::accept() {
	QString * del = new QString( "log_prefix" );
	emit sigDelTargetOpt( del );
	del = new QString( "log_level" );
	emit sigDelTargetOpt( del );
	del = new QString( "log_tcp_seq" );
	emit sigDelTargetOpt( del );
	del = new QString( "log_tcp_options" );
	emit sigDelTargetOpt( del );
	del = new QString( "log_ip_options" );
	emit sigDelTargetOpt( del );


	if ( c_log_prefix->isChecked() ) {
		QPtrList<QString>* options = new QPtrList<QString>;
		QString* name = new QString( "log_prefix" );
		QString* opt = new QString( "" );
		QString val = t_log_prefix->text();
		opt->append( val );
		options->append( opt );
		emit sigAddTargetOpt( name, options );
	}
	if ( c_log_level->isChecked() ) {
		QPtrList<QString>* options = new QPtrList<QString>;
		QString* name = new QString( "log_level" );
		QString* opt = new QString( "" );
		QString val = cb_log_level->currentText();
		opt->append( val );
		options->append( opt );
		emit sigAddTargetOpt( name, options );
	}
	if ( c_log_tcp_seq->isChecked() ) {
		QPtrList<QString>* options = new QPtrList<QString>;
		QString* name = new QString( "log_tcp_seq" );
		QString* opt = new QString( "" );
		QString val = " ";
		opt->append( val );
		options->append( opt );
		emit sigAddTargetOpt( name, options );
	}
	if ( c_log_tcp_options->isChecked() ) {
		QPtrList<QString>* options = new QPtrList<QString>;
		QString* name = new QString( "log_tcp_options" );
		QString* opt = new QString( "" );
		QString val = " ";
		opt->append( val );
		options->append( opt );
		emit sigAddTargetOpt( name, options );
	}
	if ( c_log_ip_options->isChecked() ) {
		QPtrList<QString>* options = new QPtrList<QString>;
		QString* name = new QString( "log_ip_options" );
		QString* opt = new QString( "" );
		QString val = " ";
		opt->append( val );
		options->append( opt );
		emit sigAddTargetOpt( name, options );
	}
	emit sigDocumentChanged();
	emit sigHideMe();
	//	QDialog::accept();
}

void KMFRuleEditTargetLog::slotHelp() {
	kdDebug() << "void KMFRuleEditTargetLog::slotHelp()" << endl;
	kapp->invokeHelp( "targets" );
}
void KMFRuleEditTargetLog::reject() {
	kdDebug() << "void KMFRuleEditTargetLog::slotreject()" << endl;
	emit sigHideMe();
}
#include "kmfruleedittargetlog.moc"
