/***************************************************************************
                       kmfoutputviewer.cpp  -  description
                          -------------------
 begin                : Mon Jan 28 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : a9806056@unet.univie.ac.at
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/ 
// QT includes
#include <qlabel.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qstring.h>
#include <qmessagebox.h>
#include <qfile.h>
#include <qdir.h>
#include <qtextstream.h>
#include <qsizepolicy.h> 
//KDE includes
#include <kurl.h>
#include <kstandarddirs.h>
#include <kdebug.h>
#include <klocale.h>
#include <kapplication.h>
#include <kconfig.h>
#include <ktempfile.h>
#include <kmessagebox.h>
#include <kiconloader.h>

// STD includes
#include <iostream>

//My Includes
#include "../core/kmferror.h"
#include "../core/kmferrorhandler.h"
#include "kmfoutputviewer.h"
#include "kmfprocout.h"
#include "../core/kmfdoc.h"

KMFOutputViewer::KMFOutputViewer( QWidget* parent, const char* name, WFlags fl ) : QWidget( parent, name, fl ) {
	m_err = new KMFError();
	m_err_handler = new KMFErrorHandler( "KMFOutputViewer" );
	temp_file = new KTempFile();
	temp_file2 = new KTempFile();
	setCaption( i18n( "KMyFirewall" ) );
	loadIcons();
	initGUI();
	setEnabled( false );
}

KMFOutputViewer::~KMFOutputViewer() {
	temp_file->close();
	temp_file2->close();
	temp_file->unlink();
	temp_file2->unlink();
	m_proc_out->close();
	delete m_proc_out;
}
void KMFOutputViewer::loadApp( KMyFirewall *app ) {
	m_app = app;
	setEnabled( true );
}


void KMFOutputViewer::initGUI() {
	kdDebug() << "void KMFOutputViewer::initGUI()" << endl;

	m_bclose = new QPushButton( this, "m_bclose" );
	m_bclose->setText( i18n( "Close" ) );
	connect( m_bclose, SIGNAL( clicked() ), this, SLOT( slotCloseWindow() ) );

	m_proc_out = new KMFProcOut( this, "m_proc_out", false );
	connect( m_proc_out, SIGNAL( sigJobFinished( bool, const QString& ) ), this, SLOT( slotJobFinished( bool, const QString& ) ) );
	//	m_proc_out->resize( 500, 600 );

	m_layout = new QGridLayout( this, 1, 1, 2, 2 );
	m_layout->addWidget( m_proc_out, 0, 0 );
	m_layout->addWidget( m_bclose, 1, 0 );

	adjustSize();
}
void KMFOutputViewer::slotCloseWindow() {
	emit sigHideMe();
}

void KMFOutputViewer::slotJobFinished( bool ok, const QString& cmd_name ) {
	kdDebug() << "void KMFOutputViewer::slotJobFinished(bool ok,const QString& cmd_name)" << endl;
	if ( cmd_name == "Install Firewall" && ok ) {  // installation successful
		const QString & msg = i18n( "<p>Installation of the firewall finished successfully. "
		                            "The firewall will startup during the next reboot.<br>"
		                            "If you want the firewall to be started now click <b>OK</b> and then <b>Run Firewall</b>" );
		const QString& cap = "Install Firewall";
		KMessageBox::information( this, msg, cap );

	} else if ( cmd_name == "Install Firewall" && !ok ) { // installation failed
		const QString & msg = i18n( "<p><b>Installation of firewall failed</b><br>"
		                            "<p>Please make sure you are logged in as <b>root</b>" );
		const QString& cap = "Install Firewall";
		KMessageBox::error( this, msg, cap );
	} else if ( cmd_name == "Uninstall Firewall" && ok ) { // uninstallation successful
		const QString & msg = i18n( "<p>Uninstallation of the firewall finished successfully. "
		                            "The firewall will no longer startup during boot.<br>"
		                            "If you want the firewall to be stopped now click <b>OK</b> and then <b>Stop Firewall</b>" );
		const QString& cap = "Install Firewall";
		KMessageBox::information( this, msg, cap );
	} else if ( cmd_name == "Uninstall Firewall" && !ok ) { // uninstallation failed
		const QString & msg = i18n( "<p><b>Uninstallation of Firewall failed</b><br>"
		                            "Please make sure you are logged in as <b>root</b>" );
		const QString& cap = "Uninstall Firewall";
		KMessageBox::error( this, msg, cap );
	} else if ( !ok ) {
		const QString & msg = i18n( "<p>Execution of <b>%1</b> failed"
		                            "<p>Click <b>OK</b> to check your configuration and make sure you are logged in as <b>root</b>" ).arg( cmd_name );
		const QString& cap = "KMFOutputViewer";
		KMessageBox::error( this, msg, cap );
	}
	emit sigStatusChanged();
}

void KMFOutputViewer::slotRunFW() {
	kdDebug() << "void KMFOutputViewer::slotRunFW()" << endl;
	int doit = KMessageBox::questionYesNo ( this , i18n( "<p><b>Are you sure you want to execute the generated iptables script?</b>"
	                                        "<p><b>A wrongly configured iptables script may make your computer unuseable!</b>"
	                                        "<p>If your system hangs after you start the firewall, switch to a text "
	                                        "console (Ctrl+Alt+F1) and run the following commands to reset your iptables "
	                                        "configuration:"
	                                        "<p><ul>"
	                                        "<li>iptables -F </li>"
	                                        "<li>iptables -X </li>"
	                                        "<li>iptables -P INPUT ACCEPT </li>"
	                                        "<li>iptables -P OUTPUT ACCEPT </li>"
	                                        "<li>iptables -P FORWARD ACCEPT </li>"
	                                        "<li>iptables -t nat -F </li>"
	                                        "<li>iptables -t nat -X </li>"
	                                        "<li>iptables -t nat -P OUTPUT ACCEPT </li>"
	                                        "<li>iptables -t nat -P PREROUTING ACCEPT </li>"
	                                        "<li>iptables -t nat -P POSTROUTING ACCEPT </li>"
	                                        "<li>iptables -t mangle -F </li>"
	                                        "<li>iptables -t mangle -X </li>"
	                                        "<li>iptables -t mangle -P INPUT ACCEPT </li>"
	                                        "<li>iptables -t mangle -P OUTPUT ACCEPT </li>"
	                                        "<li>iptables -t mangle -P FORWARD ACCEPT </li>"
	                                        "<li>iptables -t mangle -P PREROUTING ACCEPT </li>"
	                                        "<li>iptables -t mangle -P POSTROUTING ACCEPT </li></ul>" ),
	                                        i18n( "Run Firewall" ), KStdGuiItem::yes(), KStdGuiItem::no(), "output_view_run_fw" );
	kdDebug() << "Message Box returned: " << doit << endl;
	if ( doit == 3 ) {
		//		m_proc_out->show();
		//		m_proc_out->raise();
		const QString file = temp_file->name();
		m_err = m_app->getDoc() ->createFirewallScript( file );
		if ( m_err_handler->showError( m_err ) ) {
			kdDebug() << "Starting Firewall..." << endl;
			QString fw_script = "/bin/sh " + file + " start";
			kdDebug() << "url.path() :" << file << endl;
			QString cmd_name = "/bin/sh " + file + " start";
			m_proc_out->runCmd( fw_script, cmd_name );
			KConfig* _config = kapp->config();
			_config->setGroup( "FIREWALL_STATUS" );
			_config->writeEntry( "running", "on" );
			_config->sync();
			emit sigStatusChanged();
		}
	}
}

void KMFOutputViewer::slotStopFW() {
	kdDebug() << "Shutdown Firewall..." << endl;
	const QString file = temp_file->name();
	m_err = m_app->getDoc() ->createFirewallScript( file );
	if ( m_err_handler->showError( m_err ) ) {
		QString fw_script = "/bin/sh " + file + " stop";
		kdDebug() << "url.path() :" << file << endl;
		//		m_proc_out->show();
		//		m_proc_out->raise();
		m_proc_out->runCmd( fw_script, fw_script );
		KConfig* _config = kapp->config();
		_config->setGroup( "FIREWALL_STATUS" );
		_config->writeEntry( "running", "off" );
		_config->sync();
		emit sigStatusChanged();
	}
}

void KMFOutputViewer::slotShowAll() {
	kdDebug() << "Show Config..." << endl;
	kdDebug() << "iptables" << "-L" << endl;
	//	m_proc_out->show();
	//	m_proc_out->raise();
	KConfig* _config = kapp->config();
	_config->setGroup( "PATHS" );
	str_ipt = _config->readPathEntry( "ipt_path" );
	if ( str_ipt.isEmpty() ) {
		const QString & msg = i18n( "<p>Path to the iptables program was not found." );
		m_err->setErrType( "NORMAL" );
		m_err->setErrMsg( msg );
		m_err_handler->showError( m_err );
		return ;
	}
	QString show_config = "IPT=\"" + str_ipt + "\"\n"
	                      "echo \"Config of Table FILTER:\"\n"
	                      "echo\n"
	                      "$IPT -L\n"
	                      "echo\n"
	                      "echo\n"
	                      "echo \"Config of Table NAT:\"\n"
	                      "echo\n"
	                      "$IPT -t nat -L\n"
	                      "echo\n"
	                      "echo\n"
	                      "echo \"Config of Table MANGLE:\"\n"
	                      "echo\n"
	                      "$IPT -t mangle -L \n";
	QString cmd_name = str_ipt + " -L; " + str_ipt + " -t nat -L; " + str_ipt + " -t mangle -L ";
	m_proc_out->runCmd( show_config, cmd_name );
}

void KMFOutputViewer::slotShowFilter() {
	kdDebug() << "Show Config..." << endl;
	kdDebug() << "iptables" << " -t filter -L" << endl;
	//	m_proc_out->show();
	//	m_proc_out->raise();
	KConfig* _config = kapp->config();
	_config->setGroup( "PATHS" );
	str_ipt = _config->readPathEntry( "ipt_path" );
	if ( str_ipt.isEmpty() ) {
		const QString & msg = i18n( "<p>Path to the iptables program was not found." );
		m_err->setErrType( "NORMAL" );
		m_err->setErrMsg( msg );
		m_err_handler->showError( m_err );
		return ;
	}
	QString show_config = "IPT=\"" + str_ipt + "\"\n"
	                      "echo \"Config of Table FILTER:\"\n"
	                      "echo\n"
	                      "$IPT -t filter -L\n";
	QString cmd_name = str_ipt + " -t filter -L";
	m_proc_out->runCmd( show_config, cmd_name );
}
void KMFOutputViewer::slotShowNat() {
	kdDebug() << "Show Config..." << endl;
	kdDebug() << "iptables" << " -t nat -L" << endl;
	//	m_proc_out->show();
	//	m_proc_out->raise();
	KConfig* _config = kapp->config();
	_config->setGroup( "PATHS" );
	str_ipt = _config->readPathEntry( "ipt_path" );
	if ( str_ipt.isEmpty() ) {
		const QString & msg = i18n( "<p>Path to the iptables program was not found." );
		m_err->setErrType( "NORMAL" );
		m_err->setErrMsg( msg );
		m_err_handler->showError( m_err );
		return ;
	}
	QString show_config = "IPT=\"" + str_ipt + "\"\n "
	                      "echo \"Config of Table NAT:\"\n"
	                      "echo\n"
	                      "$IPT -t nat -L \n";
	QString cmd_name = str_ipt + " -t nat -L";
	m_proc_out->runCmd( show_config, cmd_name );
}
void KMFOutputViewer::slotShowMangle() {
	kdDebug() << "Show Config..." << endl;
	kdDebug() << "iptables" << " -t mangle -L" << endl;
	//	m_proc_out->show();
	//	m_proc_out->raise();
	KConfig* _config = kapp->config();
	_config->setGroup( "PATHS" );
	str_ipt = _config->readPathEntry( "ipt_path" );
	if ( str_ipt.isEmpty() ) {
		const QString & msg = i18n( "<p>Path to the iptables program was not found." );
		m_err->setErrType( "NORMAL" );
		m_err->setErrMsg( msg );
		m_err_handler->showError( m_err );
		return ;
	}
	QString show_config = "IPT=\"" + str_ipt + "\"\n"
	                      "echo \"Config of Table NAT:\"\n"
	                      "echo\n"
	                      "$IPT -t mangle -L \n";
	QString cmd_name = str_ipt + " -t mangle -L";
	m_proc_out->runCmd( show_config, cmd_name );
}

void KMFOutputViewer::slotShowScript() {
	kdDebug() << "KMFOutputViewer::slotShowScript()" << endl;
	const QString file = temp_file->name();

	m_err = m_app->getDoc() ->createFirewallScript( file );
	if ( m_err_handler->showError( m_err ) ) {
		if ( !file.isEmpty() ) {
			//			m_proc_out->show();
			//			m_proc_out->raise();
			QFile f( file );
			bool isopen = f.open( IO_ReadOnly );
			if ( isopen ) {
				QTextStream ts( &f );
				QString test;
				while ( !ts.eof() ) {
					QString s;
					s = ts.readLine();
					test.append( s );
					test.append( "\n" );
				}
				m_proc_out->setText( test );
				f.close();
				kdDebug() << "Removing Temp script file" << endl;
			} else {
				KMessageBox::sorry( this, i18n( "Input file %1 could not be opened." ).arg( file ), i18n( "Output Viewer" ) );
			}
		} else {
			KMessageBox::sorry( this, i18n( "Unable to find input file" ), i18n( "Output Viewer" ) );
		}
	}
}

void KMFOutputViewer::slotInstallFW() {
	kdDebug() << "KMFOutputViewer::slotInstallFW()" << endl;
	int doit = KMessageBox::questionYesNo ( this , i18n( "<p><b>Are you sure you want to install the firewall on your computer?</b>"
	                                        "<p>This will add the scripts to your init system that are required to "
	                                        "start your firewall during bootup."
	                                        "<p><b>Please make sure that the firewall runs properly before you install it.</b>" ),
	                                        i18n( "Install Firewall" ), KStdGuiItem::yes(), KStdGuiItem::no(), "output_view_install_fw" );
	kdDebug() << "Message Box returned: " << doit << endl;
	if ( doit == 3 ) {
		//		m_proc_out->show();
		//		m_proc_out->raise();
		KConfig * _config = kapp->config();
		_config->setGroup( "PATHS" );
		QString gentoo_mode = _config->readEntry( "gentoo_mode" );
		kdDebug() << "gentoo_mode = " << gentoo_mode << endl;
		QString init_path = _config->readPathEntry( "init_path" );
		kdDebug() << "init_path = " << init_path << endl;
		QString rc_default_path = _config->readPathEntry( "rc_default_path" );
		kdDebug() << "rc_default_path = " << rc_default_path << endl;



		KURL url = KGlobal::dirs() ->findResource( "appdata", "scripts/kmfinstall.sh" );
		QString installscript = url.path();

		if ( installscript.isEmpty() ) {
			QString msg = i18n( "<p>Unable to find install script <b>kmfinstall.sh</b>"
			                            "<p>Please check your installation. Usually this script is installed in "
			                            "$KDEDIR/share/apps/kmyfirewall/scripts"
			                            "<p>Unable to install the firewall without this script." );
			QString cap = "KMFOutputViewer";
			KMessageBox::error( this, msg, cap );
			return ;
		}
		kdDebug() << "found Install script: " << installscript << endl;
		if ( gentoo_mode == "false" ) {
			QString msg = i18n( "<p>The following files will be created by installing the firewall"
			                            "<ul><li>Directory: %1</li>"
			                            "<li>File: %2</li>"
			                            "<li>File: %3</li>"
			                            "<li>Link: %4 -&gt; %5</li>"
			                            "<li>Link: %6 -&gt; %7</li></ul></ul>" )
			                            .arg("/etc/kmyfirewall")
			                            .arg("/etc/kmyfirewall/kmyfirewall.sh")
			                            .arg(init_path + "/kmyfirewall")
			                            .arg(rc_default_path + "/S99kmyfirewall")
			                            .arg(init_path + "/kmyfirewall")
			                            .arg(rc_default_path + "/K01kmyfirewall")
			                            .arg(init_path + "/kmyfirewall");
			QString cap = i18n( "Install Firewall" );
			KMessageBox::information( this, msg, cap, "created_install_files", 0 );
		} else {
			QString msg = i18n( "<p>The following files will be created by installing the firewall"
			                            "<ul><li>Directory: %1</li>"
			                            "<li>File: %2</li>"
			                            "<li>File: %3</li>"
			                            "<li>Link: %4 -&gt; %5</li></ul></ul>" )
			                            .arg("/etc/kmyfirewall")
			                            .arg("/etc/kmyfirewall/kmyfirewall.sh")
			                            .arg(init_path + "/kmyfirewall")
			                            .arg(rc_default_path + "/kmyfirewall")
			                            .arg(init_path + "/kmyfirewall");
			QString cap = i18n( "Install Firewall" );
			KMessageBox::information( this, msg, cap, "created_install_files", 0 );
		}

		const QString fwscript = temp_file->name();
		m_err = m_app->getDoc() ->createFirewallScript( fwscript );
		if ( m_err_handler->showError( m_err ) ) {
			const QString initscript = temp_file2->name();
			m_err = m_app->getDoc() ->createInitScript( initscript );
			if ( m_err_handler->showError( m_err ) ) {
				QString systemtype;
				if ( gentoo_mode == "true" )
					systemtype = "gentoo";
				else
					systemtype = "sysv";

				QString inst_cmd = "/bin/sh " + installscript + " install " + systemtype + " " + init_path + " " + rc_default_path + " " + initscript + " " + fwscript;
				QString cmd_name = "Install Firewall";
				m_proc_out->runCmd( inst_cmd, cmd_name );
			}
		}
	}
}

void KMFOutputViewer::slotUninstallFW() {
	kdDebug() << "KMFOutputViewer::slotUninstallFW()" << endl;
	int doit = KMessageBox::questionYesNo ( this , i18n( "<p><b>Are you sure you want to uninstall the firewall from your computer?</b><br>"
	                                        "The firewall will no longer start up during boot." ),
	                                        i18n( "Uninstall Firewall" ), KStdGuiItem::yes(), KStdGuiItem::no(), "output_view_uninstall_fw" );
	kdDebug() << "Message Box returned: " << doit << endl;
	if ( doit == 3 ) {
		//		m_proc_out->show();
		//		m_proc_out->raise();
		KConfig * _config = kapp->config();
		_config->setGroup( "PATHS" );
		QString gentoo_mode = _config->readEntry( "gentoo_mode" );
		kdDebug() << "gentoo_mode = " << gentoo_mode << endl;
		QString init_path = _config->readPathEntry( "init_path" );
		kdDebug() << "init_path = " << init_path << endl;
		QString rc_default_path = _config->readPathEntry( "rc_default_path" );
		kdDebug() << "rc_default_path = " << rc_default_path << endl;

		KURL url = KGlobal::dirs() ->findResource( "appdata", "scripts/kmfinstall.sh" );
		QString installscript = url.path();

		if ( installscript.isEmpty() ) {
			const QString & msg = i18n( "<p>Unable to find uninstall script <b>kmfinstall.sh</b>"
			                            "<p>Please check your installation. Usually this script is installed in "
			                            "$KDEDIR/share/apps/kmyfirewall/scripts"
			                            "<p>Unable to uninstall the firewall without this script." );
			const QString& cap = "KMFOutputViewer";
			KMessageBox::error( this, msg, cap );
			return ;
		}
		kdDebug() << "found Install script: " << installscript << endl;
		if ( gentoo_mode == "false" ) {
			QString msg = i18n( "<p>The following files will be removed by uninstalling the firewall"
			                            "<ul><li>Directory: %1</li>"
			                            "<li>File: %2</li>"
			                            "<li>File: %3</li>"
			                            "<li>Link: %4 -&gt; %5</li>"
			                            "<li>Link: %6 -&gt; %7</li></ul></ul>" )
			                            .arg("/etc/kmyfirewall")
			                            .arg("/etc/kmyfirewall/kmyfirewall.sh")
			                            .arg(init_path + "/kmyfirewall")
			                            .arg(rc_default_path + "/S99kmyfirewall")
			                            .arg(init_path + "/kmyfirewall")
			                            .arg(rc_default_path + "/K01kmyfirewall")
			                            .arg(init_path + "/kmyfirewall");
			QString cap = i18n( "Uninstall Firewall" );
			KMessageBox::information( this, msg, cap, "removed_uninstall_files", 0 );
		} else {
			QString msg = i18n( "<p>The following files will be removed by uninstalling the firewall"
			                            "<ul><li>Directory: %1</li>"
			                            "<li>File: %2</li>"
			                            "<li>File: %3</li>"
			                            "<li>Link: %4 -&gt; %5</li></ul></ul>" )
			                            .arg("/etc/kmyfirewall")
			                            .arg("/etc/kmyfirewall/kmyfirewall.sh")
			                            .arg(init_path + "/kmyfirewall")
			                            .arg(rc_default_path + "/kmyfirewall")
			                            .arg(init_path + "/kmyfirewall");
			QString cap = i18n( "Uninstall Firewall" );
			KMessageBox::information( this, msg, cap, "removed_uninstall_files", 0 );
		}

		QString systemtype;
		if ( gentoo_mode == "true" )
			systemtype = "gentoo";
		else
			systemtype = "sysv";

		QString inst_cmd = "/bin/sh " + installscript + " uninstall " + systemtype + " " + init_path + " " + rc_default_path;
		QString cmd_name = "Uninstall Firewall";
		m_proc_out->runCmd( inst_cmd, cmd_name );
	}
}

void KMFOutputViewer::loadIcons() {
	kdDebug() << "void KMFOutputViewer::loadIcons()" << endl;
	KIconLoader *loader = KGlobal:: iconLoader();
	QString icon_name;
	icon_name = "encrypted";
	icon_run = loader->loadIcon( icon_name, KIcon::Toolbar );

	icon_name = "decrypted";
	icon_stop = loader->loadIcon( icon_name, KIcon::Toolbar );

	icon_name = "openterm";
	icon_show = loader->loadIcon( icon_name, KIcon::Toolbar );
}

#include "kmfoutputviewer.moc"
