/***************************************************************************
 *   Copyright (C) 2004 by Marco Gulino                                    *
 *   marco.gulino@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <klocale.h>
#include <klistview.h> 
#include <kiconloader.h>
#include <kcombobox.h> 
#include <qlistview.h> 
#include <klineedit.h>
#include <kcompletion.h> 
#include <kiconloader.h>
#include <kpushbutton.h>
#include <math.h>
#include <qtimer.h>
#include <qevent.h> 
#include <kapplication.h>
#include <kinputdialog.h> 
#include <kabc/phonenumber.h> 
#include <kabc/addressee.h>

#include <kdeversion.h>
#if KDE_IS_VERSION(3,3,0)
	#include <klistviewsearchline.h> 
#endif

#include "d_pickphonebook.h"
#include "d_newsms.h"
#include "kmobiletools.h"

#include <iostream>
using namespace std;

#include "gsm.h"
extern GSM* d_gsm;
#include "threadedgsm.h"
extern threadedGSM gsmThread;
#include "c_config.h"
extern c_config* Config;

#define COL_NAME 1
#define COL_NICK 2
#define COL_NUMB 3
#define COL_NUMT 4

d_PickPhoneBook::d_PickPhoneBook(QWidget *parent, const char *name)
 : KDialogBase(parent, name, true, i18n("PhoneBook entry selection"), 
 	KDialogBase::Ok | KDialogBase::Cancel, KDialogBase::Ok, true )
{
	mainWidget=new ui_PickPhonebook(this);
	setMainWidget( mainWidget );
	mainWidget->show();
	resize( 400, 450 );
	mainWidget->l_phonebook->setColumnWidthMode(0, QListView::Manual);
	mainWidget->l_phonebook->setColumnWidth(0, 5);
	if ( QString(name)=="phonebook-dial") k_parent=(kmobiletools*) parent; else k_parent=NULL;
	if ( QString(name)=="phonebook-sms") newSMSWin=(d_NewSMS*) parent; else newSMSWin=NULL;
	mainWidget->b_refresh->setIconSet( QIconSet ( KGlobal::iconLoader()->loadIcon( "reload", KIcon::FirstGroup, KIcon::SizeSmall ) ) );
	setIcon( KGlobal::iconLoader()->loadIcon( "korganizer" , KIcon::FirstGroup, KIcon::SizeSmall ) );
// 	mainWidget->h_filter->setFocus();
	#if !KDE_IS_VERSION(3,3,0)
	connect( mainWidget->h_filter , SIGNAL( textChanged(const QString &) ), this, SLOT(filterChanged(const QString&) ) );
	#endif
	connect( mainWidget->c_memsrc, SIGNAL( activated(int) ), this, SLOT(initList(int ) ) );
	connect( mainWidget->l_phonebook, SIGNAL( doubleClicked(QListViewItem*) ), this, SLOT(slotOk() ) );
	connect( mainWidget->l_phonebook, SIGNAL( selectionChanged() ), this, SLOT(selChanged() ) );
	connect( mainWidget->b_refresh, SIGNAL( clicked() ), this, SLOT(refreshClicked() ) );
	connect( &refresh,SIGNAL(timeout()),this, SLOT(updatingSlot() ) );
// 	mainWidget->s_filter->setListView( mainWidget->l_phonebook );
	memSourcesList=Config->getPbMemUsed();
	for(QStringList::Iterator it=memSourcesList.begin(); it!=memSourcesList.end(); ++it)
	{
		mainWidget->c_memsrc->insertItem( GSM::getMemDesc(GSM::TYPE_PB, *it ).first() 
			+ " (" + GSM::getMemDesc(GSM::TYPE_PB, *it ).last() + ")" );
	}
	mainWidget->c_memsrc->setCurrentItem( Config->getLastPbMemUsed() );
	initList( mainWidget->c_memsrc->currentItem() );
}


d_PickPhoneBook::~d_PickPhoneBook()
{
}


#include "d_pickphonebook.moc"

void d_PickPhoneBook::initList( int memtype )
{
	mainWidget->l_phonebook->clear();
	enableButtonOK(false);
	using namespace KABC;
// 	d_gsm->initPhoneBook( memType );
	if(memtype==1) addressbook=StdAddressBook::self();
		else addressbook=d_gsm->getPhoneBook();
	AddressBook::Iterator addrIt=addressbook->begin();
	QStringList compl_list;
	QStringList numbers, nums;
	QString id;
	QValueList<KABC::PhoneNumber> numbersList;
	while (! addrIt->isEmpty() )
	{
		id=addrIt->uid();
		if( (memtype<3 ) ||
		( id.contains( QString("KMobileTools-").append( 
			GSM::getMemDesc( GSM::TYPE_PB, *memSourcesList.at(memtype-3) ).last() ) ) >0 )
		)
		{
			numbers.clear(); nums.clear();
			numbersList=addrIt->phoneNumbers();
			for( QValueList<KABC::PhoneNumber>::Iterator nit=numbersList.begin(); nit!=numbersList.end(); ++nit)
			{
				nums   += ( (KABC::PhoneNumber) *nit).number();
				numbers+= ( (KABC::PhoneNumber) *nit).typeLabel() + ": " + ( (KABC::PhoneNumber) *nit).number();
			}
			new KListViewItem( mainWidget->l_phonebook, id.section("KMobileTools-",1,1), addrIt->realName(),
				addrIt->nickName(), 
				nums.join(", "),
				numbers.join(",") );
		}
		addrIt++;
	}
	if(memtype==0)
	{
		addrIt=StdAddressBook::self()->begin();
		compl_list.clear();
		numbers.clear();
		nums.clear();
		numbersList.clear();
		while (! addrIt->isEmpty() )
		{
			id=addrIt->uid();
			numbers.clear(); nums.clear();
			numbersList=addrIt->phoneNumbers();
			for( QValueList<KABC::PhoneNumber>::Iterator nit=numbersList.begin(); nit!=numbersList.end(); ++nit)
			{
				nums   += ( (KABC::PhoneNumber) *nit).number();
				numbers+= ( (KABC::PhoneNumber) *nit).typeLabel() + ": " + ( (KABC::PhoneNumber) *nit).number();
			}
			new KListViewItem( mainWidget->l_phonebook, id.section("KMobileTools-",1,1), addrIt->realName(),
				addrIt->nickName(), 
			nums.join(", "),
			numbers.join(",") );
			addrIt++;
		}
	}
	mainWidget->l_phonebook->setSorting(0, true);
	#if !KDE_IS_VERSION(3,3,0)
	if (mainWidget->h_filter->text().length()>0) filterChanged(mainWidget->h_filter->text() );
	#endif
}

void d_PickPhoneBook::filterChanged(const QString &text)
{
	QListViewItemIterator it( mainWidget->l_phonebook );
	while ( it.current() ) {
		QListViewItem *item = it.current();
		if(
			item->text( COL_NAME ).contains( text, false ) !=0 ||
			item->text( COL_NICK ).contains( text, false ) !=0 ||
			item->text( COL_NUMB ).contains( text, false ) !=0 
		  )
			item->setVisible(true); else item->setVisible(false);
		++it;
    }
}

void d_PickPhoneBook::slotOk()
{
	if( mainWidget->l_phonebook->selectedItem() == 0 || mainWidget->l_phonebook->selectedItem()->text( COL_NUMB ).length()<=0 ) return;
	QString numsel=mainWidget->l_phonebook->selectedItem()->text( COL_NUMB );
	if(numsel.contains(",")>0)
	{
		numsel=KInputDialog::getItem( 
			i18n("Select number"), 
			i18n("Choose desired phone number from list"), 
			QStringList::split( ",", mainWidget->l_phonebook->selectedItem()->text( COL_NUMT ) ) );
		numsel=numsel.section(": ", 1, 1);
	}
	if(numsel.length()==0) return;
	if(k_parent!=NULL) 
	{
		k_parent->getMainWidget()->h_number->addToHistory( numsel );
		k_parent->getMainWidget()->h_number->setCurrentText( numsel );
		k_parent->show();
	}
	if(newSMSWin!=NULL) 
	{
		newSMSWin->getMainWidget()->cb_dest->addToHistory( numsel );
		newSMSWin->getMainWidget()->cb_dest->setCurrentText( numsel );
		newSMSWin->show();
	}
	Config->setLastPbMemUsed( mainWidget->c_memsrc->currentItem() );
	done(0);
}

void d_PickPhoneBook::slotCancel()
{
	Config->setLastPbMemUsed( mainWidget->c_memsrc->currentItem() );
	done(1);
}


/*!
    \fn d_PickPhoneBook::selChanged()
 */
void d_PickPhoneBook::selChanged()
{
	if(mainWidget->l_phonebook->selectedItem()!=0 && mainWidget->l_phonebook->selectedItem()->text( COL_NUMB ).length()>0 )
		enableButtonOK(true);
	else
		enableButtonOK(false);
}


/*!
    \fn d_PickPhoneBook::refreshClicked()
 */
void d_PickPhoneBook::refreshClicked()
{
	d_gsm->setAbInited(false);
	if( Config->getPbClear() ) d_gsm->getPhoneBook()->clear();
	gsmThread.initPhoneBook();
	updating=new KProgressDialog( this, "sync", i18n("Synchronization"), i18n("Synchronizing your mobile phone with KDE Address Book.\nPlease wait...."), true );
	updating->showCancelButton(false);
	updating->progressBar()->setTextEnabled(false);
	progressVersus=1;
	updating->show();
// 	refresh=new QTimer(this);
	refresh.start(9, false);
}


/*!
    \fn d_PickPhoneBook::updatingSlot()
 */
void d_PickPhoneBook::updatingSlot()
{
	updating->progressBar()->setProgress( updating->progressBar()->progress() + progressVersus );
	if( updating->progressBar()->progress() >=99 || updating->progressBar()->progress()<=0 ) progressVersus*=-1;
	updating->showCancelButton(false);
	if( d_gsm->getAbInited() ) {
		KApplication::postEvent( updating, new QCloseEvent () );
		refresh.stop();
		d_gsm->parsePhoneBook();
		initList( mainWidget->c_memsrc->currentItem() );
	}
}
