# spec file for package kmetronome (Version 1.3.0)
#
# norootforbuild

Name:           kmetronome
Version:        1.3.0
Release:        0
License:        GPL v2 or later
Summary:        MIDI Metronome using ALSA Sequencer
Group:          Productivity/Multimedia/Sound/Midi
URL:            http://kmetronome.sourceforge.net
Source:         %name-%version.tar.bz2
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
BuildRequires:  cmake
BuildRequires:  alsa-lib-devel
BuildRequires:  qt5-qtbase-devel
BuildRequires:  qt5-qtsvg-devel
BuildRequires:  qt5-qttools-devel
BuildRequires:  libdrumstick-devel

%description
Drumstick Metronome is a MIDI metronome with Qt interface, based on the ALSA 
sequencer. Intended for musicians and music students, it is a tool to keep 
the rhythm while playing musical instruments. It uses MIDI for sound 
generation instead of digital audio, allowing low CPU usage, and very 
accurate timing thanks to the ALSA sequencer.



Authors:
--------
    Pedro Lopez-Cabanillas <plcl@users.sourceforge.net>

%prep
%setup -q

%build
%cmake
make %{?jobs:-j %jobs} VERBOSE=1

%install
make install DESTDIR=$RPM_BUILD_ROOT

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc INSTALL README ChangeLog AUTHORS TODO
%doc %{_mandir}/man1/*
%dir %{_datadir}/%name
%dir %{_datadir}/icons/hicolor/*/apps
%dir %{_datadir}/dbus-1/services
%dir %{_datadir}/dbus-1/interfaces
%{_bindir}/%name
%{_datadir}/applications/%name.desktop
%{_datadir}/dbus-1/*/*
%{_datadir}/icons/hicolor/*/*/*
%{_datadir}/%name/*

%changelog
* Thu Dec 31 2020 Pedro Lopez-Cabanillas <plcl@users.sourceforge.net> 1.2.0
- New release
* Tue Nov 5 2019 Pedro Lopez-Cabanillas <plcl@users.sourceforge.net> 1.0.1
- New release
* Sun Oct 12 2014 Pedro Lopez-Cabanillas <plcl@users.sourceforge.net> 1.0.0
- Initial version
