/***************************************************************************
                                qsimage.h
                             -------------------                                         
    begin                : 01-January-2000
    copyright            : (C) 2000 by Kamil Dobkowski                         
    email                : kamildobk@poczta.onet.pl                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef QSIMAGE_H
#define QSIMAGE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include"qsaxes.h"
#include"qsplot.h"
#include"qsdrv.h"



/**
  * \brief Dataset: Draws pixmaps
  *
  * Data format is described in QSImage::Channels . See also QSAxes::plotAdd() .
  * @author Kamil Dobkowski
  */
class QSImage : public QSPlot2D
  {
   Q_OBJECT
	Q_PROPERTY( bool rawMode READ rawMode WRITE setRawMode )
	Q_PROPERTY( bool useGradient READ useGradient WRITE setUseGradient )

   public:
        /**
          * Descriptive names of data channels. See QSData::setMatrix().
	  * DataRed is required, other matrices are optional. DataRed, DataIndex, DataGray are the different names
	  * for the same channel. DataRed, DataGreen, DataBlue must have the same size.
	  * XVector ( optional ) contains x coordinates of a grid, YVector ( optional ) contains y coordinates of a grid.
	  * cols(XVector) == cols(DataRed)+1, rows(YVector) == rows(DataRed)+1, both vectors must be monotone.
          */
    enum Channels {
                XVector		= 0,     // Row vector, monotone. Size w+1 x 1
       	        YVector		= 1,     // Column vector, monotone. Size 1 x h+1
                DataRed		= 2,  // 2 Matrix. Size: w x h ( size is width x height ).
                DataIndex	= 2,  // 2
                DataGray	= 2,  // 2
                DataGreen	= 3,  // Matrix. Size w x h
                DataBlue	= 4,  // Matrix. Size w x h
                Palette 	= 5     // Matrix. Size 3 x ?
                };
   /**
     * Constructor.
     */
     QSImage(QSAxes* parent, const char * name=0);
   /**
     * Destructor.
     */
     ~QSImage();
     /**
       * Sets the raw mode. In the raw mode the value axis has
       * fixed range 0-255, and there is no mapping of data values
       * to the axis.
       */
     void setRawMode( bool enabled );
     /**
       * Returns the  current state of the raw mode setting.
       */
     bool rawMode() const { return m_rawmode; }
     /**
       * Use gradient instead of gray levels
       */
     void setUseGradient( bool enable );
     /**
       *  if using gradient
       */
     bool useGradient() const  { return m_use_gradient; }

     virtual QString posInfo( QSPt2f& pos );
     virtual bool isClicked( const QSPt2f& pos );
     virtual QSPt2f legendItemSize( QSDrv *drv );
     virtual void drawLegendItem( const QSPt2f& pos, QSDrv *drv );
	virtual void loadStateFromStream( QDataStream& stream, QSObjectFactory *factory );
	virtual void saveStateToStream( QDataStream& stream, QSObjectFactory *factory );
        virtual ColumnType columnType( int channel, int column ) const;
	virtual QString channelVariable( int channel ) const;

    protected:

      virtual void dataChanged( int channel = -1 );
      virtual void allocRuntimeData();
      virtual void freeRuntimeData();
      virtual bool getAxisRange( QSAxis *axis, double& min, double& max );
      virtual bool start();
      virtual bool step();
      virtual void end();

    private:

      bool m_evalid;
      bool m_rawmode;
      bool m_use_gradient;
      double m_dmin;
      double m_dmax;
      unsigned char m_r;
      unsigned char m_g;
      unsigned char m_b;
      unsigned char *m_ptr;
	struct image_runtime_data;
      struct image_runtime_data *d;

      bool init_buffers();
      bool clip_rect(  QSPt2& p1, QSPt2& p2  );
      void set_rgb( unsigned char* ptr, int x_index, int y_index );
   };

#endif











































