/***************************************************************************
                               qsdrvhittest.h
                             -------------------                                         
    begin                : 01-January-2000
    copyright            : (C) 2000 by Kamil Dobkowski                         
    email                : kamildobk@poczta.onet.pl                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef QSDRVHITTEST_H
#define QSDRVHITTEST_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include<qobject.h>
#include"qsdrvqt.h"

//-------------------------------------------------------------//

/**
  * \brief Implementation of QSDrv for testing which graph element is at the given position
  *
  * Hit testing driver. To find out if an object was hit you must repaint it with
  * QSHitDrv and next check if isHit() flag is set. QSHitDrv also emits signal
  * hitDetected when isHit() flag is set and QSHitDrv is being deleted - so you can
  * also use it when drawing in background. To find out what element was drawn, when hit
  * was detected call hitCategory() and hitElement().
  * @author Kamil Dobkowski
  */
class QSDrvHitTest : public QObject, public QSDrvQt
 {
	Q_OBJECT
  public:
	QSDrvHitTest( const QSPt2f& hitPosition, QObject *parent = NULL );
	virtual ~QSDrvHitTest();
        virtual QSDrvHitTest *copy();
	void copySettingsFrom( const QSDrvHitTest *drv );
	bool isHit() const { return m_is_hit; }
	int hitCategory() const { return m_category; }
	int hitElement() const { return m_element; }
	QSPt2f hitPosition() const { return m_hit_pos; }
	virtual void clearCanvas( const QSGFill& f, const QSPt2f& pos, const QSPt2f& size );
	virtual void drawLine( const QSPt2f &one, const QSPt2f &two );
	virtual void beginPolyline( const QSPt2f& pos );
	virtual void drawPolylineTo( const QSPt2f& pos );
	virtual void endPolyline();
	virtual QSPt2f currPolylinePos() { return m_curr_polyline_pos; }
	virtual void drawRect( const QSPt2f &p1, const QSPt2f &p2 );
	virtual void drawPoly( const QSPt2f pts[], int npoints, const bool edges[] = NULL, int edgeAutoColor = 0 );
	virtual void drawEllipse( const QSPt2f& p1, const QSPt2f& p2  );
	virtual void drawText( const QSPt2f &pos, const QString& text, int align = AlignLeft | AlignBottom );
	virtual void drawRText( const QSPt2f &pos, int angle, const QString& text, int align = AlignLeft | AlignBottom );
	virtual void getPixmapBuffer( PixmapBuffer *buff, int pwidth, int pheight );
	virtual void drawPixmap( const QSPt2f& pos, PixmapBuffer *data );
	virtual void setFill( const QSGFill &f );
	virtual void setLine( const QSGLine &l );
  signals:
	void hitDetected( int hitCategory, int hitElement );
  protected:
	QSPt2f m_hit_pos;
	bool m_is_hit;
	int m_hit_category;
	int m_hit_element;
	int m_curr_pixmap_width;
	QSGFill m_curr_fill;
	QSGLine m_curr_line;
	void hit();
 };


#endif











































































