/***************************************************************************
                               qsdrvhittest.cpp
                             -------------------                                         
    begin                : 01-January-2000
    copyright            : (C) 2000 by Kamil Dobkowski                         
    email                : kamildobk@poczta.onet.pl                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include"qsdrvhittest.h"
#include<assert.h>


//
// After each hit test the depth ( z-coordinate ) of hit point should be
// calculated ( maybe in QSProjection ). The final hit should be one with the
// smallest z-coordinate
//
//-------------------------------------------------------------//

QSDrvHitTest::QSDrvHitTest( const QSPt2f& hitPosition, QObject *parent )
:QObject(parent), QSDrvQt()
 {
  m_hit_pos = hitPosition;
  m_hit_category = -1;
  m_hit_element  = -1;
  m_is_hit = false;
 }

//-------------------------------------------------------------//

QSDrvHitTest::~QSDrvHitTest()
 {
  if ( m_is_hit ) emit hitDetected( m_hit_category, m_hit_element );
 }

//-------------------------------------------------------------/

QSDrvHitTest *QSDrvHitTest::copy()
 {
  QSDrvHitTest *result = new QSDrvHitTest( m_hit_pos );
  result->copySettingsFrom( this );
  return result;
 }

//-------------------------------------------------------------//

void QSDrvHitTest::copySettingsFrom( const QSDrvHitTest *drv )
 {
  QSDrvQt::copySettingsFrom( drv );
 }

//-------------------------------------------------------------//

void QSDrvHitTest::clearCanvas( const QSGFill&, const QSPt2f&, const QSPt2f& )
  {
  }

//-------------------------------------------------------------//

void QSDrvHitTest::drawLine( const QSPt2f &begin, const QSPt2f &end  )
  {
   if ( m_curr_line.style != QSGLine::Invisible )  {
       QSPt2f p1 = begin;
       QSPt2f p2 = end;
       if ( QSProjection::clipLine( &p1, &p2, QSPt2f(m_hit_pos.x-2.0,m_hit_pos.y-2.0), QSPt2f(4.0,4.0) ) ) hit();
      }
  }

//-------------------------------------------------------------//

void QSDrvHitTest::drawEllipse( const QSPt2f& p1, const QSPt2f& p2 )
 {
  drawRect( p1, p2 );
 }

//-------------------------------------------------------------//

void QSDrvHitTest::drawRect( const QSPt2f &p1, const QSPt2f &p2 )
 {
  if ( m_curr_line.style != QSGLine::Invisible &&
       m_curr_fill.style != QSGFill::Transparent ) {
	QSRectf r = QSRectf( p1, p2-p1 ).normalize();
	r.size.x += 1.0;
	r.size.y += 1.0;
	if ( r.contains(m_hit_pos) ) hit();
	}
 }

//-------------------------------------------------------------//

void QSDrvHitTest::drawPoly( const QSPt2f p[], int npoints, const bool edges[], int edgeAutoColor )
 {
    if ( m_curr_line.style != QSGLine::Invisible ||
         m_curr_fill.style != QSGFill::Transparent )
	if ( QSProjection::pointInPoly(m_hit_pos,p,npoints) ) hit();
 }

//-------------------------------------------------------------//

void QSDrvHitTest::drawText( const QSPt2f &pos, const QString& text, int align )
// ups !
 {
  drawRText( pos, 0, text, align );
 }

//-------------------------------------------------------------//

void QSDrvHitTest::drawRText( const QSPt2f &pos, int angle, const QString& text, int align )
 {
  QSPt2f p[4];
  getRTextBoundingPoly( p, pos, angle, text, align );
  if ( QSProjection::pointInPoly(m_hit_pos,p,4) ) hit();
 }

//-------------------------------------------------------------//

void QSDrvHitTest::getPixmapBuffer( PixmapBuffer *buff, int pwidth, int pheight )
 {
  QSDrvQt::getPixmapBuffer( buff, pwidth, pheight );
  m_curr_pixmap_width = pwidth;
 }

//-------------------------------------------------------------//

void QSDrvHitTest::drawPixmap( const QSPt2f& pos, PixmapBuffer *buff )
 {
  QSRectf r( pos.x, pos.y, m_curr_pixmap_width, buff->lines );
  if ( r.contains( m_hit_pos ) ) hit();
 }

//-------------------------------------------------------------//

void QSDrvHitTest::beginPolyline( const QSPt2f& pos )
  {
   m_curr_polyline_pos = pos;
  }

//-------------------------------------------------------------//

void QSDrvHitTest::drawPolylineTo( const QSPt2f& pos )
  {
   drawLine( m_curr_polyline_pos, pos );
   m_curr_polyline_pos = pos;
  }

//-------------------------------------------------------------//

void QSDrvHitTest::endPolyline()
 {
 }

//-------------------------------------------------------------//

void QSDrvHitTest::setFill( const QSGFill &f )
  {
   m_curr_fill = f;
  }

//-------------------------------------------------------------//

void QSDrvHitTest::setLine( const QSGLine &l )
  {
   m_curr_line = l;
  }

//-------------------------------------------------------------//

void QSDrvHitTest::hit()
  {
   m_is_hit = true;
   m_hit_category = currentCategory();
   m_hit_element  = currentElement();
  }


