/***************************************************************************
                               qsctool.h
                             -------------------
    begin                : Sun Jan 30 2000
    copyright            : (C) 2000 by Kamil Dobkowski
    email                : kamildbk@friko.onet.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef QSCTOOL_H
#define QSCTOOL_H

#include<qobject.h>
#include<qevent.h>
#include"qscoord.h"

class QSPlotView;
class QSDrvQt;

 /**
  * \brief Tool creates and edits QSCObject's on the canvas.
  *
  * It works in conjuction with QSPlotView, see QSPlotView::setTool().
  * It do nothing, but offers virtual functions notifing about some events
  * on the canvas such as mouse button click, key press, drag, etc. See also
  * activate(), deactivate().
  */
class QSTool : public QObject
  {
	Q_OBJECT
   public:
    /**
      * Constructor.
      */
	QSTool( QObject *parent = NULL );
    /**
      * Destructor
      */
	virtual ~QSTool();
    /**
      * Called when the tool is activated. QSPlotView::currentPage(), QSPlotView::zoom(), QSPlotView::dpi()
      * QSPlotView::fullPage() are constant between activate() and deactivate(). If zoom is going to change
      * deactivate() is called, zoom changes and activate() is called next().
      *
      */
	virtual void activate( QSPlotView *parentView );
    /**
      * Called when the tool is deactivated. Tools should not perform any action when they are deactivated.
      */
	virtual void deactivate();
    /**
      * Mouse and key event handler for a canvas.
      * If event wasn't proccesed this function should
      * return FALSE. There is no need to use this
      * function directly - use canvas...() functions insted.
      */
	virtual bool canvasEvent( QEvent *e );
    /**
      * Intended to draw handles, frames etc. around active objects.
      * Called when drawing ends in a parent widget
      * ( after graphics has been closed ).
      */
	virtual void draw() {}

   protected:
	/**
	  * Canvas event. Left button click over the canvas. 'button' consist of 'ButtonState' flags ORed together
	  */
	virtual void canvasClicked( const QPoint& pos, int keyState );
	/**
	  * Canvas event. Middle button click over the canvas.
	  */
	virtual void canvasMiddleButtonClicked( const QPoint& pos, int keyState );
	/**
	  * Canvas event. Right mouse button pressed over the canvas.
	  */
	virtual void canvasRightButtonClicked( const QPoint& pos, int keyState );
	/**
	  * Right button double-click. Warning ! two canvasClicked events are emitted before they are became double click event.
	  */
	virtual void canvasDoubleClicked( const QPoint& pos, int keyState );
	/**
	  * Canvas event. Drags start - user pressed the mouse and is going to move the mouse with the button pressed.
	  * If function returns false drag is not started ( canvasDragEnd() is not emitted in this case ).
	  */
	virtual bool canvasDragStart( const QPoint& pos, int keyState );
	/**
	  * Canvas event. User drags ( moves the mouse with the button pressed ) around.
	  */
	virtual void canvasDragMove( const QPoint& pos, const QPoint& prevPos, const QPoint& startPos, int keyState, int prevKeyState, int startKeyState );
	/**
	  * Canvas event. User relesed mouse pointer after drawing operation. It is guaranteed that
	  * the last mouse canvasDragMove event had the same 'pos' as this event.
	  */
	virtual void canvasDragEnd( const QPoint& pos, const QPoint& startPos, int keyState, int startKeyState );
	/**
	  * Mouse move over the canvas. This event is not sent during dragging
	  */
	virtual void canvasMove( const QPoint& pos );
     /**
       * Rounds canvas coordinates to view's grid.( if SHIFT key is not pressed ).
       */	
	QSPt2f snapToGrid( const QPoint& pos, int keyState=0 );
     /**
       * Rounds canvas coordinates to view's grid.( if SHIFT key is not pressed ).
       */	
	QSPt2f snapToGrid( const QSPt2f& pos, int keyState=0 );
     /**
       * Rounds x canvas coordinate  to view's grid.Always set
       * 'snap_to_grid' to true.
       */
     	double snapToGridX( double canvas_x, int keyState=0 );
     /**
       * Rounds y canvas coordinate to view's grid.
       */
     	double snapToGridY( double canvas_y, int keyState=0 );
	/**
	  * Rounds range
	  */
	int snapAngle( int angle, int keyState=0 );
	/**
	  * Canvas event - this is low-level function.
	  */
	virtual bool eventMouseDblClick( QMouseEvent * );
	/**
	  * Canvas event - this is low-level function. Use 'canvasClicked' instead.
	  */
	virtual bool eventMousePress( QMouseEvent*  );
	/**
	  * Canvas event - this is low-level function. Use 'canvasClicked' instead.
	  */
	virtual bool eventMouseRelease( QMouseEvent*  );
	/**
	  * Canvas event - this is low-level function. Use 'canvasDragMove' instead.
	  */
	virtual bool eventMouseMove( QMouseEvent*  );
	/**
	  * Canvas event - this is low-level function.
	  */
	virtual bool eventKeyPress(  QKeyEvent*  );
	/**
	  * Canvas event - this is low-level function.
	  */
	virtual bool eventKeyRelease( QKeyEvent*  );
      /**
       	* Returns a graphics driver, which can be used to draw on the canvas, and
       	* enters in th edit mode.
       	*/
     	QSDrvQt *driver();

	QSDrvQt    *m_drv;
	QSPlotView *m_view;
  private:
	enum State { 	StateReady = 0,
			StateLeftButtonPressed,
			StateMiddleButtonPressed,
			StateRightButtonPressed,
			StateDragging };
	State m_state;
	bool m_snap_to_grid;
        QPoint m_drag_start_pos;
	QPoint m_drag_prev_pos;
	int m_drag_start_key;
	int m_drag_prev_key;
	void release_driver();
  };

#endif
