/***************************************************************************
                                 qscoord.cpp
                             -------------------                                         
    begin                : 01-January-2000
    copyright            : (C) 2000 by Kamil Dobkowski                         
    email                : kamildobk@poczta.onet.pl                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "qscoord.h"

//-------------------------------------------------------------//
/*
ostream& operator<<( ostream& s, const QSPt& p )
 {
  return s << "(" << p.x << ", " << p.y << ")" ;
 }
*/
//-------------------------------------------------------------//

QSPt2 operator+ ( const QSPt2& p1, const QSPt2& p2 )
  {
   return QSPt2( p1.x+p2.x, p1.y+p2.y );
  }

//-------------------------------------------------------------//

QSPt2 operator- ( const QSPt2& p1, const QSPt2& p2 )
  {
   return QSPt2( p1.x-p2.x, p1.y-p2.y );
  }

//-------------------------------------------------------------//

bool operator==( const QSPt2& p1, const QSPt2& p2 )
  {
   return p1.x == p2.x && p1.y == p2.y;
  }

//-------------------------------------------------------------//

bool operator!=( const QSPt2& p1, const QSPt2& p2 )
  {
   return !( p1 == p2 );
  }

//-------------------------------------------------------------//
/*
ostream& operator<<( ostream& s, const QSPt3& p )
 {
  return s << "(" << p.x << ", " << p.y << ", " << p.z << ")" ;
 }
*/
//-------------------------------------------------------------//

QSPt3 operator+ ( const QSPt3& p1, const QSPt3& p2 )
  {
   return QSPt3( p1.x+p2.x, p1.y+p2.y, p1.z+p2.z );
  }

//-------------------------------------------------------------//

QSPt3 operator- ( const QSPt3& p1, const QSPt3& p2 )
  {
   return QSPt3( p1.x-p2.x, p1.y-p2.y, p1.z-p2.z );
  }

//-------------------------------------------------------------//

bool operator==( const QSPt3& p1, const QSPt3& p2 )
  {
   return p1.x == p2.x && p1.y == p2.y && p1.z == p2.z;
  }

//-------------------------------------------------------------//

bool operator!=( const QSPt3& p1, const QSPt3& p2 )
  {
   return !( p1 == p2 );
  }

//-------------------------------------------------------------//
/*
ostream& operator<<( ostream& s, const QSPtf& p )
 {
  return s << "(" << p.x << ", " << p.y << ")" ;
 }
*/
//-------------------------------------------------------------//

QSPt2f operator+ ( const QSPt2f& p1, const QSPt2f& p2 )
 {
  return QSPt2f( p1.x+p2.x, p1.y+p2.y );
 }

//-------------------------------------------------------------//

QSPt2f operator- ( const QSPt2f& p1, const QSPt2f& p2 )
 {
  return QSPt2f( p1.x-p2.x, p1.y-p2.y );
 }

//-------------------------------------------------------------//

bool operator==( const QSPt2f& p1, const QSPt2f& p2 )
 {
  return p1.x == p2.x && p1.y == p2.y;
 }

//-------------------------------------------------------------//

bool operator!=( const QSPt2f& p1, const QSPt2f& p2 )
 {
  return !( p1 == p2 );
 }

//-------------------------------------------------------------//
/*
ostream& operator<<( ostream& s, const QSPt3f& p )
 {
  return s << "(" << p.x << ", " << p.y << ", " << p.z << ")" ;
 }
*/
//-------------------------------------------------------------//

QSPt3f operator+ ( const QSPt3f& p1, const QSPt3f& p2 )
 {
  return QSPt3f( p1.x+p2.x, p1.y+p2.y, p1.z+p2.z );
 }

//-------------------------------------------------------------//

QSPt3f operator- ( const QSPt3f& p1, const QSPt3f& p2 )
 {
  return QSPt3f( p1.x-p2.x, p1.y-p2.y, p1.z-p2.z );
 }

//-------------------------------------------------------------//

bool operator==( const QSPt3f& p1, const QSPt3f& p2 )
 {
  return p1.x == p2.x && p1.y == p2.y && p1.z == p2.z;
 }

//-------------------------------------------------------------//

bool operator!=( const QSPt3f& p1, const QSPt3f& p2 )
 {
  return !( p1 == p2 );
 }

//-------------------------------------------------------------//

bool operator==( const QSRectf& r1, const QSRectf& r2 )
 {
  return r1.pos == r2.pos && r1.size == r2.size;
 }

//-------------------------------------------------------------//

bool operator!=( const QSRectf& r1, const QSRectf& r2 )
 {
  return !( r1 == r2 );
 }

//-------------------------------------------------------------//

bool QSRectf::contains( const QSPt2f& point ) const
 {
  QSRectf r = QSRectf(pos,size).normalize();
  return point.x >= r.pos.x && point.x <= r.pos.x+r.size.x && point.y >= r.pos.y && point.y <= r.pos.y+r.size.y;
 }

//-------------------------------------------------------------//

QSRectf QSRectf::normalize() const
 {
  return QSRectf(  size.x<0 ? pos.x+size.x : pos.x,
  	           size.y<0 ? pos.y+size.y : pos.y,
  	           size.x<0 ? -size.x : size.x,
  	           size.y<0 ? -size.y : size.y );
 }

//-------------------------------------------------------------//

QSRectf QSRectf::normalizeWidth() const
 {
  return QSRectf(  size.x<0 ? pos.x+size.x : pos.x,
  	           pos.y,
  	           size.x<0 ? -size.x : size.x,
  	           size.y );
 }

//-------------------------------------------------------------//

QSRectf QSRectf::normalizeHeight() const
 {
  return QSRectf(  pos.x,
  	           size.y<0 ? pos.y+size.y : pos.y,
  	           size.x,
  	           size.y<0 ? -size.y : size.y );
 }

//-------------------------------------------------------------//

QRect QSRectf::rect() const
 {
  return QRect( int(pos.x+0.5),
  		int(pos.y+0.5),
  		int(pos.x+size.x+0.5)-int(pos.x+0.5),
  		int(pos.y+size.y+0.5)-int(pos.y+0.5) );
 }

//-------------------------------------------------------------//

void QSRectf::setTopLeft( const QSPt2f& p ) {
	if ( size.x >= 0 ) setP1( QSPt2f(p.x, p1().y) ); else setP2( QSPt2f(p.x, p2().y) );
	if ( size.y >= 0 ) setP1( QSPt2f(p1().x, p.y) ); else setP2( QSPt2f(p2().x, p.y) );
	}

//-------------------------------------------------------------//

void QSRectf::setBottomRight( const QSPt2f& p ) {
	if ( size.x < 0 ) setP1( QSPt2f(p.x, p1().y) ); else setP2( QSPt2f(p.x, p2().y) );
	if ( size.y < 0 ) setP1( QSPt2f(p1().x, p.y) ); else setP2( QSPt2f(p2().x, p.y) );
	}

//-------------------------------------------------------------//

QSPt2f QSRectf::topLeft() const {
	return QSPt2f( QMIN(pos.x,pos.x+size.x), QMIN(pos.y,pos.y+size.y) );
	}

//-------------------------------------------------------------//

QSPt2f QSRectf::bottomRight() const {
	return QSPt2f( QMAX(pos.x,pos.x+size.x), QMAX(pos.y,pos.y+size.y) );
	}

//-------------------------------------------------------------//

void QSRectf::unite( const QSRectf& rect ) {
	setTopLeft( QSPt2f( QMIN( topLeft().x, rect.topLeft().x ),
		            QMIN( topLeft().y, rect.topLeft().y ) ) );
	setBottomRight( QSPt2f( QMAX( bottomRight().x, rect.bottomRight().x ),
				QMAX( bottomRight().y, rect.bottomRight().y )  ) );
 	}


