/***************************************************************************
                          qsconsole.h  -  description
                             -------------------
    begin                : Wed Jan 16 2002
    copyright            : (C) 2002 by kamil
    email                : kamil@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef QSCONSOLE_H
#define QSCONSOLE_H

#include<qstring.h>

/**
  * \brief Sink for text messages generated by the library
  *
  * You will have to reimplement this class if you want to receive text messages from this library.
  * Notice a little trick - if you create an object of this class a static pointer is set to this object.
  * in the constructor.
  * @author kamil
  */
class QSConsole {
   public:
	/**
	  * Constructor. Calls m_default_console = this.
	  */
	QSConsole();
	/**
	  * Destructor. Calls if ( m_default_console == this ) m_default_console = NULL.
	  */
	virtual ~QSConsole();
	/**
	  * Use this function to write text to the default console
	  */
	static void write( const QString& message );

   protected:
	/**
	  * You have to reimplement this function in your own custom console.
	  */
	virtual void appendText( const QString& message ) = 0;
	/**
	  * Pointer to the default console. It is auto set when you creates
	  * an console object.
	  */
	static QSConsole *m_default_console;	
  };

#endif
