/***************************************************************************
                                  ksetmatrix.cc
                             -------------------
    begin                : Sun Jun 25 2000
    copyright            : (C) 2000 by Kamil Dobkowski
    email                : kamildobk@friko.onet.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <octave/oct.h>
#include <iostream.h>
#include <errno.h>
#include "octave-common.h"

//------------------------------------------------------------------//

DEFUN_DLD (ksetmatrix, args, ,
" usage: ksetmatrix(dataset,channel,matrix)\n"
"\n"
"Sets the matrix 'matrix' as channel 'channel' in plot application.\n"
"See also: ksetaxes, ksetplot, kadd, kremove, kremoveall, kaddaxes, kremoveaxes, kplot, kimage, kcontour, kmesh\n" )
{
 int dataset;
 int channel;
 if ( args.length() != 3 ) {
     	error("wrong number of arguments.");
       }
 else
 if ( (dataset=(int )args(0).double_value()) < 0 ||
      (channel=(int )args(1).double_value()) < 0 ) {
     	error("channel and dataset number must be >= 0.");
	}
 else {
	int socket_fd = plot_connect( appNumber(), NULL, NULL );
	if ( socket_fd == -1 && errno < sys_nerr && errno >= 0 ) {
			 error( sys_errlist[errno] );
			 return octave_value_list();
		        }
	Matrix m = args(2).matrix_value();
        setMatrix( socket_fd, dataset, channel, m );
 	plot_disconnect( socket_fd );
    }

 return octave_value_list();
}

