/***************************************************************************
                                  kadd.cpp
                             -------------------
    begin                : Sun Jun 25 2000
    copyright            : (C) 2000 by Kamil Dobkowski
    email                : kamildobk@friko.onet.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <octave/oct.h>
#include <iostream.h>
#include <errno.h>
#include "octave-common.h"

//------------------------------------------------------------------//

DEFUN_DLD (kadd, args, ,
" usage: kadd(type)\n"
"\n"
"Adds a new dataset to the current axes:\n"
" 0 - curve\n"
" 1 - image\n"
" 2 - contour\n"
" 3 - surface\n"
" 4 - figure\n"
"See also: kremove, kremoveall, kaddaxes, kremoveaxes, ksetapp, ksetplot, kplot, kimage, kcontour, kmesh, ksetmatrix\n" )
{
 int dataset_number = -1;
 int type = (int )args(0).double_value();
 if ( type < 0 || type > 4 ) {
      	error("Type must be 0, 1, 2, 3, 4 .");
     } else {
      	int socket_fd = plot_connect( appNumber(), NULL, NULL );
      	if ( socket_fd == -1 && errno < sys_nerr && errno >= 0 ) {
			 error( sys_errlist[errno] );
			 return octave_value_list();
			 }
 	dataset_number = plot_add_dataset( socket_fd, axesNumber(), (PlotType )type );
 	plot_disconnect( socket_fd );
     }
 return octave_value_list( (double )dataset_number );
}

