/***************************************************************************
                                  ksworksheetdlg.cpp
                             -------------------
    begin                : Tue Mar 6 2001
    copyright            : (C) 2001 by Kamil Dobkowski
    email                : kamildobk@poczta.onet.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
#include "ksworksheetdlg.h"
#include "dialogs/kschannellist.h"
#include "ksdataobjectfactory.h"
#include "widgets/qscurve.h"
#include "widgets/qsimage.h"
#include "widgets/qscontour.h"
#include "widgets/qssurface.h"
#include "widgets/qsfigure.h"
#include "widgets/qsaxes2d.h"
#include "widgets/qsaxes3d.h"
#include "widgets/qsplotview.h"
#include "ksglobalmatrixlist.h"
#include "ksdelunay.h"
#include "kscommands.h"
#include "ksobjectfactory.h"
#include "dialogs/ksimportdlg.h"
#include "dialogs/ksexportdlg.h"
#include "ksmatrixeditor.h"
#include "dialogs/ksmpanels.h"
#include "dialogs/kswizarddlgs.h"

#include <qlabel.h>
#include <qmessagebox.h>
#include <qpushbutton.h>
#include <qcombobox.h>
#include <qlayout.h>
#include <qprogressdialog.h>
#include <qtabbar.h>
#include <qsplitter.h>
#include <qaction.h>
#include <qapplication.h>
#include <qpopupmenu.h>
#include <qmenubar.h>
#include <qcursor.h>

//#include <qaction.h>
//#include <kmenubar.h>
//#include <kedittoolbar.h>
#include <qfiledialog.h>
//#include <kapp.h>

//
// Uwzglednial selection i puste miejsca
// Editor powinien resizowac macierz
//

//
// Co to jest m_curr_object i m_curr_page ????????????????!!!!!!!!!!!!!!!!!!!!!
//
class KSObjectListItem : public QListViewItem
 {
  public:
	KSObjectListItem( QListView *parent, QSData *object, const QString& title )
	 : QListViewItem(parent), m_object(object) {
		setText( 0, title );
		}
	KSObjectListItem( QListViewItem *parent, QSData *object, const QString& title )
	 : QListViewItem(parent), m_object(object) {
		setText( 0, title );
		}
	~KSObjectListItem() {
		}
	QSData *object() const { return m_object; }
  private:
	QSData *m_object;
 };

//--------------------------------------------------------------------//


KSWorksheetDlg::KSWorksheetDlg( KSWorkbook *workbook, QSPlotView *view, QWidget *parent, const char *name )
: QWidget( parent, name )
 {
  m_view = view;

  m_workbook = workbook;
  connect( m_workbook, SIGNAL(sigPageListChanged()), this, SLOT(slot_page_list_changed()) );
  connect( m_workbook->sheets(), SIGNAL(sigChildListChanged()), this, SLOT(slot_object_list_changed()) );
  connect( m_workbook->commandHistory(), SIGNAL(sigNewUndo()), this, SLOT(slot_new_undo()) );
  connect( m_workbook->commandHistory(), SIGNAL(sigNewRedo()), this, SLOT(slot_new_redo()) );

  //setCaption(tr("Worksheet"));
  //resize( 660, 450 );

  //
  // Create actions
  //
  /*
  m_new_sheet = new QAction( tr("Sheet"), tr("&New sheet"), 0, this, "new_sheet" );
  connect( m_new_sheet, SIGNAL(activated()), this, SLOT(slotNewSheet()) );
  m_new_matrix = new QAction( tr("Numerical"), tr("N&umerical matrix"), 0, this, "new_matrix" );
  connect( m_new_matrix, SIGNAL(activated()), this, SLOT(slotNewMatrix()) );
  m_new_string = new QAction( tr("String"), tr("&String matrix"), 0, this, "new_string" );
  connect( m_new_string, SIGNAL(activated()), this, SLOT(slotNewString()) );
  m_new_formula = new QAction( tr("Formula"), tr("&Formula matrix"), 0, this, "new_formula" );
  connect( m_new_formula, SIGNAL(activated()), this, SLOT(slotNewFormula()) );
  m_new_reference = new QAction( tr("Range"), tr("&Point to: sheet cell range"), 0, this, "new_reference" );
  connect( m_new_reference, SIGNAL(activated()), this, SLOT(slotNewReference()) );

  m_import_data = new QAction( tr("Import"), tr("&Import data ..."), 0, this, "import_data" );
  connect( m_import_data, SIGNAL(activated()), this, SLOT(slotImportData()) );
  m_export_data = new QAction( tr("Export"), tr("&Export data ..."), 0, this, "export_data" );
  connect( m_export_data, SIGNAL(activated()), this, SLOT(slotExportData()) );

  m_close = new QAction( tr("Close"), tr("&Close"), 0, this, "close" );
  connect( m_close, SIGNAL(activated()), this, SLOT(close()) );

  m_undo = new QAction( tr("Undo"), tr("&Undo"), CTRL+Key_Z, this, "undo" );
  connect( m_undo, SIGNAL(activated()), this, SLOT(slotUndo()) );
  m_redo = new QAction( tr("Redo"), tr("&Redo"), CTRL+Key_Y, this, "redo" );
  connect( m_redo, SIGNAL(activated()), this, SLOT(slotRedo()) );
  slot_new_undo();
  slot_new_redo();

  m_copy = new QAction( tr("Copy"), tr("&Copy"), CTRL+Key_C, this, "copy" );
  connect( m_copy, SIGNAL(activated()), this, SLOT(slotCopy()) );
  m_copy_all = new QAction( tr("Copy all"), tr("&Copy with data"), 0, this, "copy_all" );
  connect( m_copy_all, SIGNAL(activated()), this, SLOT(slotCopyAll()) );
  m_paste = new QAction( tr("Paste"), tr("&Paste"), CTRL+Key_V, this, "paste" );
  connect( m_paste, SIGNAL(activated()), this, SLOT(slotPaste()) );
  m_cut = new QAction( tr("Cut"), tr("C&ut"), CTRL+Key_X, this, "cut" );
  connect( m_cut, SIGNAL(activated()), this, SLOT(slotCut()) );
  m_delete = new QAction( tr("Delete"), tr("&Delete"), 0, this, "delete" );
  connect( m_delete, SIGNAL(activated()), this, SLOT(slotDelete()) );
  m_detach = new QAction( tr("Detach"), tr("&Detach"), 0, this, "detach" );
  connect( m_detach, SIGNAL(activated()), this, SLOT(slotDetach()) );
  m_transpose = new QAction( tr("Transpose"), tr("&Transpose"), 0, this, "transpose" );
  connect( m_transpose, SIGNAL(activated()), this, SLOT(slotTranspose()) );

  m_series = new QAction( tr("XY plot"), tr("Multiple XY series - use all columns: (X),(DX),Y,(DY) "), 0, this, "series" );
  connect( m_series, SIGNAL(activated()), this, SLOT(slotNewSeriesAuto()) );
  m_pixmap = new QAction( tr("Pixmap"), tr("Pixmap - Use the current sheet "), 0, this, "pixmap_direct" );
  connect( m_pixmap, SIGNAL(activated()), this, SLOT(slotNewPixmapDirect()) );
  m_contour = new QAction( tr("Contour"), tr("Use the current sheet ..."), 0, this, "contour_direct" );
  connect( m_contour, SIGNAL(activated()), this, SLOT(slotNewContourDirect()) );
  m_contour_delunay= new QAction( tr("Contour delunay"), tr("Delunay triangulation - use columns: X, Y, Z "), 0, this, "contour_delunay" );
  connect( m_contour_delunay, SIGNAL(activated()), this, SLOT(slotNewContourDelunay()) );
  m_surface = new QAction( tr("Surface"), tr(" Surface - Use the current sheet ..."), 0, this, "surface" );
  connect( m_surface, SIGNAL(activated()), this, SLOT(slotNewSurfaceDirect()) );
  m_surface_delunay = new QAction( tr("Surface delunay"), tr("Delunay triangulation - use columns: X, Y, Z "), 0, this, "surface_delunay" );
  connect( m_surface_delunay, SIGNAL(activated()), this, SLOT(slotNewSurfaceDelunay()) );
  m_figure_trajectory = new QAction( tr("Trajectory"), tr("Trajectory/Scatter - use columns: X,Y,Z "), 0, this, "figure_trajectory" );
  connect( m_figure_trajectory, SIGNAL(activated()), this, SLOT(slotNewFigureTrajectory()) );

  //
  // Build menu
  //
  QPopupMenu *file = new QPopupMenu( this );
  menuBar()->insertItem( "&File", file );
  m_new_sheet->addTo( file );
  file->insertSeparator();
  m_new_matrix->addTo( file );
  m_new_string->addTo( file );
  m_new_formula->addTo( file );
  m_new_reference->addTo( file );
  file->insertSeparator();
  m_import_data->addTo( file );
  m_export_data->addTo( file );
  file->insertSeparator();
  m_close->addTo( file );

  QPopupMenu *edit = new QPopupMenu( this );
  menuBar()->insertItem( "&Edit", edit );
  m_undo->addTo( edit );
  m_redo->addTo( edit );
  edit->insertSeparator();
  m_cut->addTo( edit );
  m_copy->addTo( edit );
  m_copy_all->addTo( edit );
  m_paste->addTo( edit );
  m_delete->addTo( edit );
  edit->insertSeparator();
  m_transpose->addTo( edit );
  m_detach->addTo( edit );

  QPopupMenu *graph = new QPopupMenu( this );
  menuBar()->insertItem( "&Graph", graph );
  m_series->addTo( graph );
  m_pixmap->addTo( graph );
  m_contour->addTo( graph );
  m_contour_delunay->addTo( graph );
  m_surface->addTo( graph );
  m_surface_delunay->addTo( graph );
  m_figure_trajectory->addTo( graph );


  m_main_view = this;
  //new QWidget( this );
  //setCentralWidget( m_main_view );

  m_page_list = new QComboBox( m_main_view );
  m_page_list->setEditable( false );
  m_page_list->setFixedWidth( 210 );

  QSplitter *splitter = new QSplitter( QSplitter::Vertical, m_main_view );
  splitter->setFixedWidth( 210 );

  m_object_list = new QListView( splitter );
  m_object_list->setSorting(-1);
  m_object_list->setAllColumnsShowFocus( true );
  m_object_list->setRootIsDecorated( true );
  m_object_list->setTreeStepSize( 10 );
  m_object_list->setMultiSelection(false);
  m_object_list->setVScrollBarMode( QListView::AlwaysOn );
  m_object_list->setHScrollBarMode( QListView::AlwaysOff );
  m_object_list->addColumn( tr("Objects"), 190 );
   //m_object_list->setFixedWidth( 210 );

  m_chan_list = new KSChannelList( splitter );
  m_chan_list->addColumn( tr("Channels"),   140 );
  m_chan_list->addColumn( tr(""),  50 );
  //m_chan_list->setFixedWidth( 210 );

  QWidget *label_place = new QWidget( m_main_view );
  label_place->setFixedHeight( 50 );
  m_chan_description = new QLabel( label_place );
  m_chan_description->setFont(QFont("helvetica", 8, 50));
  m_chan_description->move(5,0);
  m_chan_description->resize( 450, 50 );

  m_editor  = NULL;
  m_settings_panel = NULL;
  m_settings_panel_visible = true;

  QGridLayout *layout = new QGridLayout( m_main_view, 2, 2 );
  layout->setRowStretch( 0,  0 );
  layout->setRowStretch( 1, 10 );
  layout->setRowStretch( 2,  0 );
  layout->setColStretch( 0,  0 );
  layout->setColStretch( 1, 10 );

  layout->addWidget( m_page_list,    0, 0 );
  layout->addWidget( splitter,       1, 0 );

  m_panel_layout = new QGridLayout( 3, 1 );
  m_panel_layout->setRowStretch( 0, 10 );
  m_panel_layout->setRowStretch( 1,  0 );
  m_panel_layout->setRowStretch( 2,  0 );
  m_panel_layout->setColStretch( 0, 10 );
  m_panel_layout->addWidget( label_place, 0, 0 );
  layout->addMultiCellLayout( m_panel_layout, 0, 1, 1, 1 );

  m_progress_dlg = NULL;

  connect( m_page_list, SIGNAL(activated(int)), this, SLOT(slot_page_selected(int)) );

  connect( m_object_list, SIGNAL(selectionChanged(QListViewItem*)), this, SLOT(slot_object_selected(QListViewItem*)) );
  connect( m_object_list, SIGNAL(rightButtonPressed(QListViewItem*,const QPoint&,int)), this, SLOT(slot_show_menu(QListViewItem*,const QPoint&,int)) );

  connect( m_chan_list, SIGNAL(selectionChanged()), this, SLOT(slot_channel_selected()) );
  connect( m_chan_list, SIGNAL(sigDataChanged(QSData*,int)), this, SLOT(slot_data_changed(QSData*,int)) );
  connect( m_chan_list, SIGNAL(sigShowText(const QString&)), this, SLOT(slot_channel_description(const QString&)) );

  m_curr_page = NULL;
  m_curr_object = NULL;
  recreate_page_list();
  recreate_object_list();
 }

//--------------------------------------------------------------------//

KSWorksheetDlg::~KSWorksheetDlg()
 {
 }

//-----------------------------------------------------------//

void KSWorksheetDlg::recreate_page_list()
 {
  bool selected = false;
  m_page_list->clear();
  // firts item for sheet list
  m_page_list->insertItem( tr("Sheet list") );

  // next items for pages
  for( int i=0; i<m_workbook->pageCount(); i++ ) {
	m_page_list->insertItem( QString::number(i+1)+" : \""+m_workbook->page(i)->title()+"\"" );
	if ( m_workbook->page(i) == m_curr_page ) {
		m_page_list->setCurrentItem(i+1);
		selected = true;
		}
	}
  if ( selected ) update_page_list(); else setCurrentPage( -1 );
 }

//-----------------------------------------------------------//

void KSWorksheetDlg::update_page_list()
// update page list to set the current page selected
 {
  m_page_list->setCurrentItem(m_workbook->pageFind(m_curr_page)+1);
 }

//-----------------------------------------------------------------------------//

void KSWorksheetDlg::slot_page_list_changed()
 {
  recreate_page_list();
 }

//--------------------------------------------------------------------//

void KSWorksheetDlg::slot_page_selected( int index )
 {
  setCurrentPage(index-1);
 }

//-----------------------------------------------------------//

void KSWorksheetDlg::setCurrentPage( int index )
 {
  if ( m_workbook->page(index) != m_curr_page ) {
	if ( m_curr_page ) {
		disconnect( m_curr_page->objects(), SIGNAL(sigListChanged()), this, SLOT(slot_object_list_changed()) );
		disconnect( m_curr_page->objects(), SIGNAL(sigDataChildListChanged()), this, SLOT(slot_object_list_changed()) );
		}
	m_curr_page = m_workbook->page(index);
	update_page_list();
	if ( m_curr_page ) {
		connect( m_curr_page->objects(), SIGNAL(sigListChanged()), this, SLOT(slot_object_list_changed()) );
		connect( m_curr_page->objects(), SIGNAL(sigDataChildListChanged()), this, SLOT(slot_object_list_changed()) );
		}
	recreate_object_list();
	}
 }

//-----------------------------------------------------------//

void KSWorksheetDlg::recreate_object_list()
// create a list contents
 {
  int pos_x = m_object_list->contentsX();
  int pos_y = m_object_list->contentsY();

  m_object_list->clear();

  if ( m_curr_page )
  for( int i=0; i<m_curr_page->objects()->count(); i++ ) {

	// add all data object to the list
	QSCObject *curr_object = m_curr_page->objects()->object(i);
	if ( curr_object->isAxesShadow() ) {
		QSAxes *curr_axes = curr_object->parentAxes();

		// add parent axes object
		KSObjectListItem *curr_item = new KSObjectListItem( m_object_list, NULL, KSDataObjectFactory::channelNameFactory(curr_axes) );

		// add all child axes
		KSObjectListItem *curr_axes_item = new KSObjectListItem( curr_item, NULL, tr(" Axes") );
		for( int j=0; j<curr_axes->axisCount(); j++ ) {
			(void )new KSObjectListItem( curr_axes_item, curr_axes->axis(j), KSDataObjectFactory::channelNameFactory(curr_axes->axis(j)) );
			}
		m_object_list->setOpen( curr_axes_item, true );

		// add all datasets
		KSObjectListItem *curr_plot_item = new KSObjectListItem( curr_item, NULL, tr(" Datasets") );
		for( int j=0; j<curr_axes->plotCount(); j++ ) {
			(void )new KSObjectListItem( curr_plot_item, curr_axes->plot(j), KSDataObjectFactory::channelNameFactory(curr_axes->plot(j)) );
			}	
		m_object_list->setOpen( curr_plot_item, true );
	        m_object_list->setOpen( curr_item, true );
		}
	}

   // add sheets
  KSSheetList *sheets = m_workbook->sheets();
  KSObjectListItem *curr_item = new KSObjectListItem( m_object_list, NULL, KSDataObjectFactory::channelNameFactory(m_workbook->sheets()) );
  for ( int i=0; i<sheets->childCount(); i++ ) {
	(void ) new KSObjectListItem( curr_item, sheets->child(i), KSDataObjectFactory::channelNameFactory(sheets->child(i)) );
	}
  m_object_list->setOpen( curr_item, true );
  update_object_list();

  m_object_list->setContentsPos(pos_x,pos_y);
 }

//-----------------------------------------------------------//

void KSWorksheetDlg::update_object_list()
// update object list to show the current object selected
 {
  bool selected = false;
  QListViewItem *curr_item = m_object_list->firstChild();
  while ( curr_item ) {
	 KSObjectListItem *obj_item = dynamic_cast<KSObjectListItem*>(curr_item);
	 if ( obj_item && m_curr_object && obj_item->object() == m_curr_object ) {
		selected = true;
		m_object_list->setCurrentItem( obj_item );
		}
         curr_item = curr_item->itemBelow();
        }
  if ( !selected ) setCurrentObject( NULL );
 }

//-----------------------------------------------------------//

void KSWorksheetDlg::slot_object_list_changed()
 {
  recreate_object_list();
 }

//-----------------------------------------------------------//

void KSWorksheetDlg::slot_object_selected( QListViewItem *item )
 {
  KSObjectListItem *obj_item = dynamic_cast<KSObjectListItem*>(item);
  if ( obj_item ) setCurrentObject( obj_item->object() );
 }

//-----------------------------------------------------------//

void KSWorksheetDlg::setCurrentObject( QSData *object )
 {
  if ( m_curr_object != object ) {
	m_curr_object = object;
	update_object_list();
	m_chan_list->setDataObject( object, true, -1, false );
	m_chan_list->select( object, 0 );
	slot_channel_selected();
	}
 }

//-----------------------------------------------------------//

QSData *KSWorksheetDlg::selectedObject() const
 {
  KSChannelListItem *item = m_chan_list->selected();
  if ( item && item->isValid() ) return item->dataObject();
  return NULL;
 }

//-----------------------------------------------------------//

int KSWorksheetDlg::selectedChannel() const
 {
  KSChannelListItem *item = m_chan_list->selected();
  if ( item && item->isValid() ) return item->channel();
  return -1;
 }

//-----------------------------------------------------------//

QSMatrix *KSWorksheetDlg::selectedMatrix() const
 {
  KSChannelListItem *item = m_chan_list->selected();
  if ( item && item->isValid() ) return item->dataObject()->matrix(item->channel());
  return NULL;
 }

//-----------------------------------------------------------//

void KSWorksheetDlg::slot_new_undo()
 {
  //m_undo->setEnabled( m_workbook->commandHistory()->isUndoPossible() );
  //m_undo->setText( tr("Undo: ")+m_workbook->commandHistory()->undoCommandTitle() );
 }

//-----------------------------------------------------------//

void KSWorksheetDlg::slot_new_redo()
 {
  //m_redo->setEnabled( m_workbook->commandHistory()->isRedoPossible() );
  //m_redo->setText( tr("Redo: ")+m_workbook->commandHistory()->redoCommandTitle() );
 }

//-----------------------------------------------------------//

void KSWorksheetDlg::slotUndo()
 {
  m_workbook->commandHistory()->undo();
 }

//-----------------------------------------------------------//

void KSWorksheetDlg::slotRedo()
 {
  m_workbook->commandHistory()->redo();
 }

//-------------------------------------------------------------//

void KSWorksheetDlg::slotCut()
 {
  KSChannelListItem *item = m_chan_list->selected();
  if ( item && item->isValid() && item->dataObject()->matrix(item->channel()) ) {
	KSObjectFactory factory( m_workbook );
	factory.copyQSMatrixToClipboard( item->dataObject()->matrix(item->channel()) );
	m_workbook->execute( new KSCmdSetData(item->dataObject(),item->channel(),NULL) );
	}
 }

//-------------------------------------------------------------//

void KSWorksheetDlg::slotCopy()
 {
  KSChannelListItem *item = m_chan_list->selected();
  if ( item && item->isValid() && item->dataObject()->matrix(item->channel()) ) {
	KSObjectFactory factory( m_workbook );
	factory.copyQSMatrixToClipboard( item->dataObject()->matrix(item->channel()) );
	}
 }

//-------------------------------------------------------------//

void KSWorksheetDlg::slotCopyAll()
 {
  KSChannelListItem *item = m_chan_list->selected();
  if ( item && item->isValid() && item->dataObject()->matrix(item->channel()) ) {
	KSObjectFactory factory( m_workbook );
	factory.setFlags( QSObjectFactory::CopyAllData );
	factory.copyQSMatrixToClipboard( item->dataObject()->matrix(item->channel()) );
	}
 }

//-------------------------------------------------------------//

void KSWorksheetDlg::slotPaste()
 {
  KSChannelListItem *item = m_chan_list->selected();
  if ( item && item->isValid() ) {
	KSObjectFactory factory( m_workbook );
	QSMatrix *new_matrix = factory.pasteQSMatrixFromClipboard();
	if ( new_matrix ) {
		m_workbook->execute( new KSCmdSetData(item->dataObject(),item->channel(),new_matrix) ); 	
		}
	}
 }

//-----------------------------------------------------------------------------//

void KSWorksheetDlg::slotDelete()
 {
  KSChannelListItem *citem = m_chan_list->selected();
  if ( citem && citem->isValid() ) {
	 if ( citem->dataObject()->matrix(citem->channel()) ) {
         	  m_workbook->execute( new KSCmdSetData(citem->dataObject(),citem->channel(),NULL) );
		} else {
		 if ( dynamic_cast<KSSheet*>(citem->dataObject()) )
		  m_workbook->execute(new KSCmdRemoveSheet((KSSheet *)citem->dataObject(),m_workbook->sheets()));				
		}
	}
 }
//-----------------------------------------------------------------------------//

bool KSWorksheetDlg::confirm( const QString& message )
 {
  return QMessageBox::warning ( NULL, tr("Confirmation"), message, QMessageBox::Yes, QMessageBox::No, 0 ) == QMessageBox::Yes;
 }

//-----------------------------------------------------------------------------//

KSSheet *KSWorksheetDlg::get_sheet()
 {
  KSChannelListItem *citem = m_chan_list->selected();

  if (  !citem || !citem->isValid() || citem->channel() != 0 || !dynamic_cast<KSSheet*>(citem->dataObject()) ) {
         QMessageBox::warning ( NULL, tr("Error"), tr("Select a source sheet first !"), QMessageBox::Ok, 0, 0 );
	 return NULL;
	}
  return dynamic_cast<KSSheet*>(citem->dataObject());
 }

//-----------------------------------------------------------------------------//

QSAxes *KSWorksheetDlg::get_axes()
 {
  QSAxes *axes = m_view->activeAxes();
  if ( axes == NULL )  {
	QMessageBox::warning ( NULL, tr("Error"), tr("Select the target axes first !"), QMessageBox::Ok, 0, 0 );
	return NULL;
        }
  return axes;
 }

//-----------------------------------------------------------------------------//

bool KSWorksheetDlg::confirm_new_matrix( KSChannelListItem *citem )
 {
  if ( citem && citem->isValid() ) {
	if (  !citem->dataObject()->matrix(citem->channel()) || confirm(tr(" Delete the current matrix ? ")) ) {
		return true;
		}
	}
  return false;
 }

//-----------------------------------------------------------------------------//

void KSWorksheetDlg::slotNewSheet()
 {
  static int sheet_nr = 1;
  KSSheet *new_sheet = new KSSheet( m_workbook->sheets() );
  KSMatrixString *new_matrix = new KSMatrixString();
  new_matrix->resize(10,10);
  new_matrix->setDataObject( new_sheet, 0 );
  QCString name;
  name.sprintf("sheet%d",sheet_nr++ );
  new_matrix->setName( name );
  new_sheet->setMatrix( 0, new_matrix  );
  m_workbook->execute( new KSCmdAddSheet(new_sheet,m_workbook->sheets()) );
 }

//-----------------------------------------------------------------------------//

void KSWorksheetDlg::slotDetach()
 {
  KSChannelListItem *citem = m_chan_list->selected();
  if ( citem && citem->isValid() ) {
	 QSMatrix *matrix = citem->dataObject()->matrix(citem->channel());
	 if ( matrix ) {
	 	KSObjectFactory factory( m_workbook );
	 	QSMatrix *new_matrix = factory.cloneMatrix( matrix, true );
         	m_workbook->execute( new KSCmdSetData(citem->dataObject(),citem->channel(),new_matrix) );
		}
	}
 }

//-----------------------------------------------------------------------------//

void KSWorksheetDlg::slotTranspose()
 {
  KSChannelListItem *citem = m_chan_list->selected();
  if ( citem && citem->isValid() ) {
	 QSMatrix *matrix = citem->dataObject()->matrix(citem->channel());
	 if ( matrix ) m_workbook->execute( new KSCmdMatrixTranspose(matrix) );
	}
 }


//-----------------------------------------------------------------------------//

void KSWorksheetDlg::slotNewMatrix()
 {
  KSChannelListItem *citem = m_chan_list->selected();
  if ( confirm_new_matrix(citem) ) {
        m_workbook->execute( new KSCmdSetData(citem->dataObject(),citem->channel(),KSMatrix::create(EDouble)) );
	}
 }


//-----------------------------------------------------------------------------//

void KSWorksheetDlg::slotNewReference()
 {
  KSChannelListItem *citem = m_chan_list->selected();
  if ( confirm_new_matrix(citem) ) {
        m_workbook->execute( new KSCmdSetData(citem->dataObject(),citem->channel(),new KSMatrixWorksheetCellRange(m_workbook)) );
	}
 }


//-----------------------------------------------------------------------------//

void KSWorksheetDlg::slotNewString()
 {
  KSChannelListItem *citem = m_chan_list->selected();
  if ( confirm_new_matrix(citem) ) {
        m_workbook->execute( new KSCmdSetData(citem->dataObject(),citem->channel(),new KSMatrixString()) );
	}
 }

//-----------------------------------------------------------------------------//

void KSWorksheetDlg::slotNewFormula()
 {
  KSChannelListItem *citem = m_chan_list->selected();
  if ( confirm_new_matrix(citem) ) {
        m_workbook->execute( new KSCmdSetData(citem->dataObject(),citem->channel(),new KSMatrixFormula()) );
	}
 }

//-----------------------------------------------------------------------------//
	
void KSWorksheetDlg::slotNewSeriesAuto()
 {
  KSSheet *curr_sheet = get_sheet();
  if ( !curr_sheet ) return;
  QSAxes *curr_axes = get_axes();
  if ( !curr_axes ) return;

  int columns = curr_sheet->matrix(0) ? curr_sheet->matrix(0)->cols() : 0;

  int column_x  = -1;
  int column_y  = -1;
  int column_dx = -1;
  int column_dy = -1;

  KSCmdAddDatasetGroup *add_datasets = new KSCmdAddDatasetGroup();

  // Algorithm is simple and tries to be smart:
  // Scan column types from left to right and remember column numbers for
  // x, dx, y, dy data. If column of some type is found and there is already
  // assigned column number for this type ( and there is y column
  // assigned ), the new curve is created, all remembered column numbers are
  // set to 'Unknown' and the process is repeated starting from that lately
  // found column until all columns are scanned. Actually, when a new Y column
  // is found only Y and DY values are reset, so X and DX columns can be reused
  // for multiple series.
  // Examples:
  // columns Y1 Y2 Y3 -> three series (Y1), (Y2), (Y3)
  // X DX Y1 Y2 Y3 -> (X+/-DX,Y1), (X+/-DX,Y2), (X+/-DX,Y3)
  //
  for(int curr_col=0;curr_col<columns;curr_col++) {
	if ( curr_sheet->isColumnDataPresent(curr_col) ) {
		 switch( curr_sheet->columnData(curr_col).type ) {
			 case KSSheet::ColumnDX:
					if ( column_dx != -1 && column_y != -1 ) {
						add_new_series( add_datasets, curr_axes, curr_sheet, column_x, column_y, column_dx, column_dy );
						column_x  = -1;
						column_y  = -1;
						column_dx = -1;
						column_dy = -1;
						}
					column_dx = curr_col;
					break;
			 case KSSheet::ColumnDY:
                                        if ( column_dy != -1 && column_y != -1 ) {
						add_new_series( add_datasets, curr_axes, curr_sheet, column_x, column_y, column_dx, column_dy );
						column_dx = -1;	
						column_dy = -1;
						// column_x, column_dy is reused for a different series
						}
					column_dy = curr_col;
					break;
			 case KSSheet::ColumnX:
					if ( column_x != -1 && column_y != -1 ) {
						add_new_series( add_datasets, curr_axes, curr_sheet, column_x, column_y, column_dx, column_dy );
						column_x  = -1;
						column_y  = -1;
						column_dx = -1;
						column_dy = -1;
						}
					column_x  = curr_col;
					break;
                         case KSSheet::ColumnY:
					// ok series completed.
					if ( column_y != -1 ) {
						add_new_series( add_datasets, curr_axes, curr_sheet, column_x, column_y, column_dx, column_dy );
						column_dx = -1;	
						column_dy = -1;
						// column_x, column_dy is reused for a different series
						}
					column_y = curr_col;
			 default: 	break;
			}
		}
	}

  // the last series.
  if ( column_y != -1 ) {	
	 add_new_series( add_datasets, curr_axes, curr_sheet, column_x, column_y, column_dx, column_dy );
	}

  m_workbook->execute( add_datasets );
 }

//-----------------------------------------------------------------------------//

void KSWorksheetDlg::add_new_series( KSCmdAddDatasetGroup *cmd, QSAxes *axes, KSSheet *sheet, int column_x, int column_y, int column_dx, int column_dy )
 {
  QSCurve *new_curve = new QSCurve( axes );

  if ( column_x >= 0 ) {
	set_column( sheet, column_x, new_curve, QSCurve::XVector );
	}
   if ( column_y >= 0 ) {
        set_column( sheet, column_y, new_curve, QSCurve::YVector );
	}
   if ( column_dx >= 0 ) {
        set_column( sheet, column_dx, new_curve, QSCurve::DXVector );
	}
   if ( column_dy >= 0 ) {
        set_column( sheet, column_dy, new_curve, QSCurve::DYVector );
	}

  if ( sheet->columnData(column_y).title.isEmpty() ) new_curve->setTitle( tr("Column ")+QString::number(column_y) );
			                        else new_curve->setTitle( sheet->columnData(column_y).title );

  cmd->addDataset(new_curve);
 }

//-----------------------------------------------------------------------------//

void KSWorksheetDlg::set_column( KSSheet *src_sheet, int src_column, QSData *dst_object, int dst_channel )
 {
  KSMatrixWorksheetCellRange *new_data = new KSMatrixWorksheetCellRange(m_workbook);
  new_data->setWorksheet( m_workbook->sheets()->childIndex(src_sheet) );
  new_data->setColumn( src_column );
  dst_object->setMatrix( dst_channel, new_data );
 }

//-----------------------------------------------------------------------------//

void KSWorksheetDlg::slotNewPixmapDirect()
 {
  KSSheet *curr_sheet = get_sheet();
  if ( !curr_sheet ) return;
  QSAxes *curr_axes = get_axes();
  if ( !curr_axes ) return;

  KSMatrixWorksheetCellRange *new_data = new KSMatrixWorksheetCellRange(m_workbook);
  new_data->setWorksheet( m_workbook->sheets()->childIndex(curr_sheet) );
  QSImage *new_pixmap = new QSImage( curr_axes );
  new_pixmap->setMatrix( QSImage::DataGray, new_data );
  m_workbook->execute( new KSCmdAddDataset(new_pixmap) );
 }


//-----------------------------------------------------------------------------//

void KSWorksheetDlg::slotNewContourDirect()
 {
  KSSheet *curr_sheet = get_sheet();
  if ( !curr_sheet ) return;
  QSAxes *curr_axes = get_axes();
  if ( !curr_axes ) return;

  KSWizardDlgSurface d( this, m_workbook, curr_sheet, curr_axes, false );
  d.exec();
 }

//-----------------------------------------------------------------------------//

void KSWorksheetDlg::slotNewContourDelunay()
 {
  KSSheet *curr_sheet = get_sheet();
  if ( !curr_sheet ) return;
  QSAxes *curr_axes = get_axes();
  if ( !curr_axes ) return;

  int column_x = -1;
  int column_y = -1;
  int column_z = -1;
  int columns = curr_sheet->matrix(0) ? curr_sheet->matrix(0)->cols() : 0;
  for(int curr_col=0;curr_col<columns;curr_col++) {
	if ( curr_sheet->isColumnDataPresent(curr_col) ) {
		 switch( curr_sheet->columnData(curr_col).type ) {
			case KSSheet::ColumnX: column_x = curr_col; break;
			case KSSheet::ColumnY: column_y = curr_col; break;
			case KSSheet::ColumnZ: column_z = curr_col; break;
			default: break;
			}
		 if ( column_x >= 0 &&
		      column_y >= 0 &&
                      column_z >= 0 ) {
			 KSMatrixWorksheetCellRange *x_col = new KSMatrixWorksheetCellRange(m_workbook);
			 KSMatrixWorksheetCellRange *y_col = new KSMatrixWorksheetCellRange(m_workbook);
			 KSMatrixWorksheetCellRange *z_col = new KSMatrixWorksheetCellRange(m_workbook);
  			 x_col->setWorksheet( m_workbook->sheets()->childIndex(curr_sheet) );
  			 y_col->setWorksheet( m_workbook->sheets()->childIndex(curr_sheet) );
  			 z_col->setWorksheet( m_workbook->sheets()->childIndex(curr_sheet) );
                         x_col->setColumn( column_x );
                         y_col->setColumn( column_y );
                         z_col->setColumn( column_z );

                         KSDelunay *tr_object = new KSDelunay(NULL);
			 m_progress_dlg = new QProgressDialog( "Delunay triangulation ...", "Abort", 100, this, "progress", TRUE );
			 connect( tr_object, SIGNAL(sigProgress(int,bool*)), this, SLOT(slot_progress(int,bool*)) );
                         KSMatrix *triangles = tr_object->triangulation( x_col, y_col );
			 delete m_progress_dlg; m_progress_dlg = NULL;

			 if ( triangles ) {
				QSNonGriddedContour *new_contour = new QSNonGriddedContour( curr_axes );
                                new_contour->setMatrix( QSNonGriddedContour::VXCoord, x_col );
                                new_contour->setMatrix( QSNonGriddedContour::VYCoord, y_col );
                                new_contour->setMatrix( QSNonGriddedContour::VZCoord, z_col );
				new_contour->setMatrix( QSNonGriddedContour::Triangles, triangles );

 				m_workbook->execute( new KSCmdAddDataset(new_contour) );
				}

                         if ( !tr_object->error().isEmpty() )
				QMessageBox::warning ( NULL, tr("Errors and warnings"), tr_object->error(), QMessageBox::Ok, 0, 0 );
			

                         delete tr_object;
	                 break;
			}
		}
	}
 }


//-----------------------------------------------------------------------------//

void KSWorksheetDlg::slotNewSurfaceDirect()
 {
  KSSheet *curr_sheet = get_sheet();
  if ( !curr_sheet ) return;
  QSAxes *curr_axes = get_axes();
  if ( !curr_axes ) return;

  KSWizardDlgSurface d( this, m_workbook, curr_sheet, curr_axes, true );
  d.exec();
 }

//-----------------------------------------------------------------------------//

void KSWorksheetDlg::slotNewSurfaceDelunay()
 {
  KSSheet *curr_sheet = get_sheet();
  if ( !curr_sheet ) return;
  QSAxes *curr_axes = get_axes();
  if ( !curr_axes ) return;

  int column_x = -1;
  int column_y = -1;
  int column_z = -1;
  int columns = curr_sheet->matrix(0) ? curr_sheet->matrix(0)->cols() : 0;
  for(int curr_col=0;curr_col<columns;curr_col++) {
	if ( curr_sheet->isColumnDataPresent(curr_col) ) {
		 switch( curr_sheet->columnData(curr_col).type ) {
			case KSSheet::ColumnX: column_x = curr_col; break;
			case KSSheet::ColumnY: column_y = curr_col; break;
			case KSSheet::ColumnZ: column_z = curr_col; break;
			default: break;
			}
		 if ( column_x >= 0 &&
		      column_y >= 0 &&
                      column_z >= 0 ) {
			 KSMatrixWorksheetCellRange *x_col = new KSMatrixWorksheetCellRange(m_workbook);
			 KSMatrixWorksheetCellRange *y_col = new KSMatrixWorksheetCellRange(m_workbook);
			 KSMatrixWorksheetCellRange *z_col = new KSMatrixWorksheetCellRange(m_workbook);
  			 x_col->setWorksheet( m_workbook->sheets()->childIndex(curr_sheet) );
  			 y_col->setWorksheet( m_workbook->sheets()->childIndex(curr_sheet) );
  			 z_col->setWorksheet( m_workbook->sheets()->childIndex(curr_sheet) );
                         x_col->setColumn( column_x );
                         y_col->setColumn( column_y );
                         z_col->setColumn( column_z );

                         KSDelunay *tr_object = new KSDelunay(NULL);
			 m_progress_dlg = new QProgressDialog( "Delunay triangulation ...", "Abort", 100, this, "progress", TRUE );
			 connect( tr_object, SIGNAL(sigProgress(int,bool*)), this, SLOT(slot_progress(int,bool*)) );
                         KSMatrix *triangles = tr_object->triangulation( x_col, y_col );
			 delete m_progress_dlg; m_progress_dlg = NULL;
			 if ( triangles ) {
				QSFigure *new_figure = new QSFigure( curr_axes );
                                new_figure->setMatrix( QSFigure::VXCoord, x_col );
                                new_figure->setMatrix( QSFigure::VYCoord, y_col );
                                new_figure->setMatrix( QSFigure::VZCoord, z_col );
				new_figure->setMatrix( QSFigure::VTableI, triangles );
				m_workbook->execute( new KSCmdAddDataset(new_figure) );
				}

                         if ( !tr_object->error().isEmpty() )
				QMessageBox::warning ( NULL, tr("Errors and warnings"), tr_object->error(), QMessageBox::Ok, 0, 0 );
			
                         delete tr_object;
	                 break;
			}
		}
	}
 }

//                                curr_axes->plotAdd( new_figure );
//-----------------------------------------------------------------------------//

void KSWorksheetDlg::slot_progress( int percent, bool *cancel )
 {
  if ( m_progress_dlg ) {
	m_progress_dlg->setProgress( percent );
	qApp->processEvents();
	*cancel = m_progress_dlg->wasCancelled();
	}
 }

//-----------------------------------------------------------------------------//

void KSWorksheetDlg::slotNewFigureTrajectory()
 {
  KSSheet *curr_sheet = get_sheet();
  if ( !curr_sheet ) return;
  QSAxes *curr_axes = get_axes();
  if ( !curr_axes ) return;

  int column_x = -1;
  int column_y = -1;
  int column_z = -1;
  int columns = curr_sheet->matrix(0) ? curr_sheet->matrix(0)->cols() : 0;
  for(int curr_col=0;curr_col<columns;curr_col++) {
	if ( curr_sheet->isColumnDataPresent(curr_col) ) {
		 switch( curr_sheet->columnData(curr_col).type ) {
			case KSSheet::ColumnX: column_x = curr_col; break;
			case KSSheet::ColumnY: column_y = curr_col; break;
			case KSSheet::ColumnZ: column_z = curr_col; break;
			default: break;
			}
		 if ( column_x >= 0 &&
		      column_y >= 0 &&
                      column_z >= 0 ) {
			 QSFigure *new_figure = new QSFigure( curr_axes );
			 set_column( curr_sheet, column_x, new_figure, QSFigure::VXCoord );
                         set_column( curr_sheet, column_y, new_figure, QSFigure::VYCoord );
                         set_column( curr_sheet, column_z, new_figure, QSFigure::VZCoord );
			 m_workbook->execute( new KSCmdAddDataset(new_figure) );
	                 break;
			}
		}
	}

  QString error;
  if ( column_x < 0 ) error += tr("Couldn't find the X column \n");
  if ( column_y < 0 ) error += tr("Couldn't find the Y column \n");
  if ( column_z < 0 ) error += tr("Couldn't find the Z column \n");
  if ( !error.isEmpty() ) QMessageBox::warning ( NULL, tr("Warning"), error, QMessageBox::Ok, 0, 0 );
 }

//curr_axes->plotAdd( new_figure );

//-----------------------------------------------------------------------------//

void KSWorksheetDlg::toggleStatusBar()
{
/*
   if (m_show_statusbar->isChecked())
    statusBar()->show();
    else
    statusBar()->hide();

}

//-----------------------------------------------------------------------------//

void KSWorksheetDlg::toggleToolBar()
{

  if (m_show_toolbar->isChecked())
    toolBar()->show();
    else
    toolBar()->hide();

}

//-----------------------------------------------------------------------------//

void KSWorksheetDlg::slotConfAccels()
{
 //KKeyDialog::configureKeys( actionCollection(), "kmatplotworksheet.rc" );
}

//-----------------------------------------------------------------------------//

void KSWorksheetDlg::slotEditToolbars()
{
  //KEditToolbar dlg( actionCollection(), "kmatplotworksheet.rc" );
  //dlg.exec();
 //if ( dlg.exec() ) { applyMainWindowSettings( KGlobal::config(), "MainWindow" ); }
}

//--------------------------------------------------------------------//

void KSWorksheetDlg::slotSettingsPanel()
 {
  m_settings_panel_visible = !m_settings_panel_visible;
  make_settings_panel();
 }

//--------------------------------------------------------------------//

void KSWorksheetDlg::slotImportData()
 {
  KSImportDlg d( m_workbook, m_chan_list->dataObject() );
  if ( d.exec() == QFileDialog::Accepted ) d.loadAll();
 }

//-----------------------------------------------------------------------------//

void KSWorksheetDlg::slotExportData()
 {
  KSExportDlg d( m_chan_list->dataObject() );
  if ( d.exec() == QFileDialog::Accepted ) d.saveAll();
 }

//--------------------------------------------------------------------//

void KSWorksheetDlg::slot_refresh_object_list()
 {
 }

//--------------------------------------------------------------------//

void KSWorksheetDlg::slot_channel_description( const QString& text )
 {
  m_chan_description->setText( text );
 }

//--------------------------------------------------------------------//
  	
void KSWorksheetDlg::make_settings_panel()
 {
  delete m_settings_panel; m_settings_panel = NULL;
  KSChannelListItem *citem = m_chan_list->selected();
  if ( citem && citem->isValid() && m_settings_panel_visible ) {
	QSMatrix *matrix = citem->dataObject()->matrix(citem->channel());
	if ( matrix ) {
		 m_settings_panel = KSDataObjectFactory::createCfgPanel( matrix, m_workbook, m_main_view );
		}
         if ( m_settings_panel ) {
		m_panel_layout->addWidget( m_settings_panel, 2, 0 );
	        m_settings_panel->show();
		}
	}
 }

//--------------------------------------------------------------------//
  	
void KSWorksheetDlg::make_editor()
 {
  // preserve position
  QPoint pos;
  if ( m_editor ) pos = m_editor->editorContentsPos();

  delete m_editor; m_editor = NULL;
  KSChannelListItem *citem = m_chan_list->selected();
  if ( citem && citem->isValid() ) {
	m_editor = KSDataObjectFactory::createEditor( m_workbook, citem->dataObject(), citem->channel(), m_main_view );	
        if ( m_editor ) {
		m_editor->updateContents();
		// set attributes
		m_editor->setColumnTitles( KSDataObjectFactory::channelColumnTitlesFactory(citem->dataObject(),citem->channel()) );
                // show editor
		m_panel_layout->addWidget( m_editor->widget(), 1, 0 );
		m_editor->widget()->show();
 		m_editor->setEditorContentsPos( pos );
		}
	}
 }

//-----------------------------------------------------------//

void KSWorksheetDlg::slot_channel_selected()
 {
  /*
  // If object was removed calling editorm_modified() causes crash.
  if ( editor_modified() || config_panel_modified() )
  if ( confirm(tr(" Apply currently edited data from the worksheet editor ? ")) ) slot_apply();

  make_settings_panel();
  make_editor();
 }

//--------------------------------------------------------------------//

void KSWorksheetDlg::slot_data_changed( QSData *dataObject, int channel )
// data was changed
 {
  KSChannelListItem *citem = m_chan_list->selected();
  if ( citem &&
       citem->isValid() &&
       citem->dataObject() == dataObject &&
       ( citem->channel() == channel || channel == -1 ) ) {

 	// recreate settings panel if some bigger changes, update contents otherwise
  	if ( !m_settings_panel || m_settings_panel->editedMatrix() != dataObject->matrix(channel) ) make_settings_panel();
				else m_settings_panel->updateContents();

	// recreate editor if some bigger changes, update contents otherwise
  	if ( !m_editor || m_editor->editedMatrix() != dataObject->matrix(channel) ) make_editor();
				else m_editor->updateContents(); 			
	}
 }

//--------------------------------------------------------------------//

void KSWorksheetDlg::slot_show_menu(QListViewItem*, const QPoint&, int)
 {
  KSWorkbook *workbook = dynamic_cast<KSWorkbook*>(m_view->workbook());
  if ( !workbook ) return;

  QPopupMenu *menu = new QPopupMenu( m_view );
  int menu_cut      = menu->insertItem( tr("Cut") );
  int menu_copy     = menu->insertItem( tr("Copy") );
  int menu_copy_all = menu->insertItem( tr("Copy all") );
  int menu_paste    = menu->insertItem( tr("Paste") );
  int menu_delete   = menu->insertItem( tr("Delete") );
  menu->insertSeparator();
  int menu_raise = menu->insertItem( tr("Raise") );
  int menu_lower = menu->insertItem( tr("Lower") );
  int menu_to_front = menu->insertItem( tr("Bring to Front") );
  int menu_to_back  = menu->insertItem( tr("Send to Back") );

  KSSheet *selected_sheet = dynamic_cast<KSSheet*>(selectedObject());

  if ( !selected_sheet ) {
	menu->setItemEnabled( menu_cut, FALSE );
	menu->setItemEnabled( menu_copy, FALSE );
	menu->setItemEnabled( menu_copy_all, FALSE );
	menu->setItemEnabled( menu_delete, FALSE );
	menu->setItemEnabled( menu_raise, FALSE );
	menu->setItemEnabled( menu_lower, FALSE );
	menu->setItemEnabled( menu_to_front, FALSE );
	menu->setItemEnabled( menu_to_back, FALSE );
	}

  int item_id = menu->exec(QCursor::pos());

  if ( item_id == menu_cut ) {
	 slotCutSheet();
	}
  else if ( item_id == menu_copy ) {
	slotCopySheet();
	}
  else if ( item_id == menu_copy_all ) {
	slotCopyAllSheet();
	}
  else if ( item_id == menu_paste ) {
	slotPasteSheet();
	}
  else if ( item_id == menu_delete ) {
	slotDeleteSheet();
	}
  else if ( item_id == menu_to_front ) {
	slotBringToFrontSheet();
	}
  else if ( item_id == menu_to_back ) {
	slotSendToBackSheet();
	}
  else if ( item_id == menu_raise ) {
	slotRaiseSheet();
	}
  else if ( item_id == menu_lower ) {
	slotLowerSheet();
	}
 }
//--------------------------------------------------------------------//

void KSWorksheetDlg::slotCutSheet()
 {
  KSSheet *selected_sheet = dynamic_cast<KSSheet*>(selectedObject());
  if ( selected_sheet ) {
  	KSObjectFactory factory( m_workbook );
  	factory.copyKSSheetToClipboard(selected_sheet);
	m_workbook->execute(new KSCmdRemoveSheet(selected_sheet,m_workbook->sheets()));
	}
 }

//--------------------------------------------------------------------//

void KSWorksheetDlg::slotCopySheet()
 {
  KSSheet *selected_sheet = dynamic_cast<KSSheet*>(selectedObject());
  if ( selected_sheet ) {
  	KSObjectFactory factory( m_workbook );
  	factory.copyKSSheetToClipboard(selected_sheet);
	}
 }

//--------------------------------------------------------------------//

void KSWorksheetDlg::slotCopyAllSheet()
 {
  KSSheet *selected_sheet = dynamic_cast<KSSheet*>(selectedObject());
  if ( selected_sheet ) {
  	KSObjectFactory factory( m_workbook );
	factory.setFlags( KSObjectFactory::CopyAllData );
  	factory.copyKSSheetToClipboard(selected_sheet);
	}
 }

//--------------------------------------------------------------------//

void KSWorksheetDlg::slotPasteSheet()
 {
  KSObjectFactory factory( m_workbook );
  KSSheet *new_sheet = factory.pasteKSSheetFromClipboard( m_workbook->sheets() );
  if ( new_sheet ) m_workbook->execute(new KSCmdAddSheet(new_sheet,m_workbook->sheets()));
 }

//--------------------------------------------------------------------//

void KSWorksheetDlg::slotDeleteSheet()
 {
  KSSheet *selected_sheet = dynamic_cast<KSSheet*>(selectedObject());
  if ( selected_sheet ) {
	m_workbook->execute(new KSCmdRemoveSheet(selected_sheet,m_workbook->sheets()));
	}
 }

//--------------------------------------------------------------------//

void KSWorksheetDlg::slotBringToFrontSheet()
 {
  KSSheet *selected_sheet = dynamic_cast<KSSheet*>(selectedObject());
  if ( selected_sheet ) {
	m_workbook->execute(new KSCmdSheetOrder(KSCmdSheetOrder::ToFront,selected_sheet,m_workbook->sheets()));
	}
 }

//--------------------------------------------------------------------//

void KSWorksheetDlg::slotSendToBackSheet()
 {
  KSSheet *selected_sheet = dynamic_cast<KSSheet*>(selectedObject());
  if ( selected_sheet ) {
	m_workbook->execute(new KSCmdSheetOrder(KSCmdSheetOrder::ToBack,selected_sheet,m_workbook->sheets()));
	}
 }

//--------------------------------------------------------------------//

void KSWorksheetDlg::slotRaiseSheet()
 {
  KSSheet *selected_sheet = dynamic_cast<KSSheet*>(selectedObject());
  if ( selected_sheet ) {
	m_workbook->execute(new KSCmdSheetOrder(KSCmdSheetOrder::Raise,selected_sheet,m_workbook->sheets()));
	}
 }

//--------------------------------------------------------------------//

void KSWorksheetDlg::slotLowerSheet()
 {
  KSSheet *selected_sheet = dynamic_cast<KSSheet*>(selectedObject());
  if ( selected_sheet ) {
	m_workbook->execute(new KSCmdSheetOrder(KSCmdSheetOrder::Lower,selected_sheet,m_workbook->sheets()));
	}
 }
*/