/***************************************************************************
                                  kssocketio.h
                             -------------------
    begin                : Tue Jun 13 2000
    copyright            : (C) 2000 by Kamil Dobkowski
    email                : kamildobk@friko.onet.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSSOCKETIO_H
#define KSSOCKETIO_H


#include <qobject.h>
#include <qcstring.h>
#include <qmap.h>
#include "interface/msg.h"
#include "widgets/qsaxes.h"

class KMatplotShell;
class KSWorkbook;
class QSocketNotifier;

/**
  *@author Kamil Dobkowski
  */
class KSSocketIO : public QObject  {

   Q_OBJECT

 public:

   /**
     * Constructor.
     */
   KSSocketIO(QObject *parent=0, const char *name=0);

   /**
     * Destructor.
     */
    ~KSSocketIO();

    /**
      *
      */
   void setShell( KMatplotShell *shell );

   /**
     *
     */
   KMatplotShell *shell() const { return m_shell; }

   /**
     * Sets a file descriptor to use instead creating a new socket.
		 * This must be called before any part is registered.
     */
   void setFileDescriptor( int fd );

   /**
     *
     */
   int axesId( QSAxes *axes ) const;

   /**
     * Register part for message dispatching under a given 'id'.
     * If this id exist a previous part is unregistered. If it is
     * zero, the first unused id is taken. Returns part's id.
     */
   int registerAxes( QSAxes *axes, int id = 0 );

   /**
     * Unregister part.
     */
   void unregisterAxes( int id );

   /**
     * Returns application unique number or -1.
     */
   int appNumber() const { return app_number; }

   /**
     * Returns a socket path. If there is no socket or
     * a file descriptor is used this funtion returns an empty
     * string.
     */
   QCString socketName() const { return socket_name; }

 protected slots:
	
   void connection_requested(int);
   void read_data(int);
   void cleanup();
   void object_added( QSCObject *o );
   void object_removed( QSCObject *o );

 protected:

   void open_socket();
   void setup_socket( int socket_fd );
   void close_socket();

   void accept_connection();
   void connection_lost();
   void disconnect();
   void header_ready();
   int message_ready();
   void new_message();
   void reply( int code );
   int _write_data( int fd, const char *data, int len );
   QCString name_prefix();

   int available_axes_id;
   int app_number;
   int socket_fd;
   QSocketNotifier *socket_notifier;
   QCString socket_name;
   QMap<int,QSAxes*> m_axes;
   KMatplotShell *m_shell;
   KSWorkbook *m_workbook;

   struct {
	int socket_fd;
	QSocketNotifier *socket_notifier;
     } connection;

   struct {
	int    dlen;
      	int    nread;
	hdr_t  header;
	char  *data;
     } msg;

 };



#endif
